/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractShaftBlock;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.MaterialChecklist;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.block.LaunchedItem;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonInventory;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CSchematics;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SchematicannonTileEntity
extends SmartTileEntity
implements INamedContainerProvider {
    public static final int NEIGHBOUR_CHECKING = 100;
    public static final int MAX_ANCHOR_DISTANCE = 256;
    public SchematicannonInventory inventory;
    public boolean sendUpdate;
    public boolean dontUpdateChecklist;
    public int neighbourCheckCooldown;
    private SchematicWorld blockReader;
    public BlockPos currentPos;
    public BlockPos schematicAnchor;
    public boolean schematicLoaded;
    public ItemStack missingItem;
    public boolean positionNotLoaded;
    public boolean hasCreativeCrate;
    private int printerCooldown;
    private int skipsLeft;
    private boolean blockSkipped;
    private int printingEntityIndex;
    public BlockPos target;
    public BlockPos previousTarget;
    public List<IItemHandler> attachedInventories;
    public List<LaunchedItem> flyingBlocks;
    public MaterialChecklist checklist;
    public float fuelLevel;
    public float bookPrintingProgress;
    public float schematicProgress;
    public String statusMsg;
    public State state;
    public int blocksPlaced;
    public int blocksToPlace;
    public int replaceMode;
    public boolean skipMissing;
    public boolean replaceTileEntities;
    public boolean firstRenderTick;

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 16.0;
    }

    public SchematicannonTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setLazyTickRate(30);
        this.attachedInventories = new LinkedList<IItemHandler>();
        this.flyingBlocks = new LinkedList<LaunchedItem>();
        this.inventory = new SchematicannonInventory(this);
        this.statusMsg = "idle";
        this.state = State.STOPPED;
        this.printingEntityIndex = -1;
        this.replaceMode = 2;
        this.neighbourCheckCooldown = 100;
        this.checklist = new MaterialChecklist();
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (Direction facing : Iterate.directions) {
            LazyOptional capability;
            TileEntity tileEntity;
            if (!this.field_145850_b.func_195588_v(this.field_174879_c.func_177972_a(facing))) continue;
            if (AllBlocks.CREATIVE_CRATE.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)))) {
                this.hasCreativeCrate = true;
            }
            if ((tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !(capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).isPresent()) continue;
            this.attachedInventories.add((IItemHandler)capability.orElse(null));
        }
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
            if (compound.func_74764_b("CurrentPos")) {
                this.currentPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("CurrentPos"));
            }
        }
        this.statusMsg = compound.func_74779_i("Status");
        this.schematicProgress = compound.func_74760_g("Progress");
        this.bookPrintingProgress = compound.func_74760_g("PaperProgress");
        this.fuelLevel = compound.func_74760_g("Fuel");
        this.state = State.valueOf(compound.func_74779_i("State"));
        this.blocksPlaced = compound.func_74762_e("AmountPlaced");
        this.blocksToPlace = compound.func_74762_e("AmountToPlace");
        this.printingEntityIndex = compound.func_74762_e("EntityProgress");
        this.missingItem = null;
        if (compound.func_74764_b("MissingItem")) {
            this.missingItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("MissingItem"));
        }
        CompoundNBT options = compound.func_74775_l("Options");
        this.replaceMode = options.func_74762_e("ReplaceMode");
        this.skipMissing = options.func_74767_n("SkipMissing");
        this.replaceTileEntities = options.func_74767_n("ReplaceTileEntities");
        if (compound.func_74764_b("Target")) {
            this.target = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Target"));
        }
        if (compound.func_74764_b("FlyingBlocks")) {
            this.readFlyingBlocks(compound);
        }
        super.read(compound, clientPacket);
    }

    protected void readFlyingBlocks(CompoundNBT compound) {
        ListNBT tagBlocks = compound.func_150295_c("FlyingBlocks", 10);
        if (tagBlocks.isEmpty()) {
            this.flyingBlocks.clear();
        }
        boolean pastDead = false;
        for (int i = 0; i < tagBlocks.size(); ++i) {
            CompoundNBT c = tagBlocks.func_150305_b(i);
            LaunchedItem launched = LaunchedItem.fromNBT(c);
            BlockPos readBlockPos = launched.target;
            if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
                this.flyingBlocks.add(launched);
                continue;
            }
            while (!(pastDead || this.flyingBlocks.isEmpty() || this.flyingBlocks.get((int)0).target.equals((Object)readBlockPos))) {
                this.flyingBlocks.remove(0);
            }
            pastDead = true;
            if (i < this.flyingBlocks.size()) continue;
            this.flyingBlocks.add(launched);
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (!clientPacket) {
            compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
            if (this.state == State.RUNNING) {
                compound.func_74757_a("Running", true);
                if (this.currentPos != null) {
                    compound.func_218657_a("CurrentPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.currentPos));
                }
            }
        }
        compound.func_74776_a("Progress", this.schematicProgress);
        compound.func_74776_a("PaperProgress", this.bookPrintingProgress);
        compound.func_74776_a("Fuel", this.fuelLevel);
        compound.func_74778_a("Status", this.statusMsg);
        compound.func_74778_a("State", this.state.name());
        compound.func_74768_a("AmountPlaced", this.blocksPlaced);
        compound.func_74768_a("AmountToPlace", this.blocksToPlace);
        compound.func_74768_a("EntityProgress", this.printingEntityIndex);
        if (this.missingItem != null) {
            compound.func_218657_a("MissingItem", (INBT)this.missingItem.serializeNBT());
        }
        CompoundNBT options = new CompoundNBT();
        options.func_74768_a("ReplaceMode", this.replaceMode);
        options.func_74757_a("SkipMissing", this.skipMissing);
        options.func_74757_a("ReplaceTileEntities", this.replaceTileEntities);
        compound.func_218657_a("Options", (INBT)options);
        if (this.target != null) {
            compound.func_218657_a("Target", (INBT)NBTUtil.func_186859_a((BlockPos)this.target));
        }
        ListNBT tagBlocks = new ListNBT();
        for (LaunchedItem b : this.flyingBlocks) {
            tagBlocks.add((Object)b.serializeNBT());
        }
        compound.func_218657_a("FlyingBlocks", (INBT)tagBlocks);
        super.write(compound, clientPacket);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.neighbourCheckCooldown-- <= 0) {
            this.neighbourCheckCooldown = 100;
            this.findInventories();
        }
        this.firstRenderTick = true;
        this.previousTarget = this.target;
        this.tickFlyingBlocks();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickPaperPrinter();
        this.refillFuelIfPossible();
        this.skipsLeft = (Integer)this.config().schematicannonSkips.get();
        this.blockSkipped = true;
        while (this.blockSkipped && this.skipsLeft-- > 0) {
            this.tickPrinter();
        }
        this.schematicProgress = 0.0f;
        if (this.blocksToPlace > 0) {
            this.schematicProgress = (float)this.blocksPlaced / (float)this.blocksToPlace;
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 6);
        }
    }

    public CSchematics config() {
        return AllConfigs.SERVER.schematics;
    }

    protected void tickPrinter() {
        ItemStack icon;
        ItemRequirement requirement;
        boolean entityMode;
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        this.blockSkipped = false;
        if (this.state == State.STOPPED) {
            if (this.schematicLoaded) {
                this.resetPrinter();
            }
            return;
        }
        if (blueprint.func_190926_b()) {
            this.state = State.STOPPED;
            this.statusMsg = "idle";
            this.sendUpdate = true;
            return;
        }
        if (this.state == State.PAUSED && !this.positionNotLoaded && this.missingItem == null && (double)this.fuelLevel > this.getFuelUsageRate()) {
            return;
        }
        if (!this.schematicLoaded) {
            this.initializePrinter(blueprint);
            return;
        }
        if (this.printerCooldown > 0) {
            --this.printerCooldown;
            return;
        }
        if (this.fuelLevel <= 0.0f && !this.hasCreativeCrate) {
            this.fuelLevel = 0.0f;
            this.state = State.PAUSED;
            this.statusMsg = "noGunpowder";
            this.sendUpdate = true;
            return;
        }
        if (this.hasCreativeCrate && this.missingItem != null) {
            this.missingItem = null;
            this.state = State.RUNNING;
        }
        if (this.missingItem == null && !this.positionNotLoaded) {
            this.advanceCurrentPos();
            if (this.state == State.STOPPED) {
                return;
            }
            this.sendUpdate = true;
            this.target = this.schematicAnchor.func_177971_a((Vec3i)this.currentPos);
        }
        boolean bl = entityMode = this.printingEntityIndex >= 0;
        if (!this.func_145831_w().isAreaLoaded(this.target, 0)) {
            this.positionNotLoaded = true;
            this.statusMsg = "targetNotLoaded";
            this.state = State.PAUSED;
            return;
        }
        if (this.positionNotLoaded) {
            this.positionNotLoaded = false;
            this.state = State.RUNNING;
        }
        boolean shouldSkip = false;
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        if (entityMode) {
            requirement = ItemRequirement.of(this.blockReader.getEntities().get(this.printingEntityIndex));
        } else {
            blockState = BlockHelper.setZeroAge(this.blockReader.func_180495_p(this.target));
            requirement = ItemRequirement.of(blockState);
            boolean bl2 = shouldSkip = !this.shouldPlace(this.target, blockState);
        }
        if (shouldSkip || requirement.isInvalid()) {
            this.statusMsg = "searching";
            this.blockSkipped = true;
            return;
        }
        List<ItemStack> requiredItems = requirement.getRequiredItems();
        if (!requirement.isEmpty()) {
            for (ItemStack required : requiredItems) {
                if (this.grabItemsFromAttachedInventories(required, requirement.getUsage(), true)) continue;
                if (this.skipMissing) {
                    this.statusMsg = "skipping";
                    this.blockSkipped = true;
                    if (this.missingItem != null) {
                        this.missingItem = null;
                        this.state = State.RUNNING;
                    }
                    return;
                }
                this.missingItem = required;
                this.state = State.PAUSED;
                this.statusMsg = "missingBlock";
                return;
            }
            for (ItemStack required : requiredItems) {
                this.grabItemsFromAttachedInventories(required, requirement.getUsage(), false);
            }
        }
        this.state = State.RUNNING;
        this.statusMsg = blockState.func_177230_c() != Blocks.field_150350_a || entityMode ? "placing" : "clearing";
        ItemStack itemStack = icon = requirement.isEmpty() || requiredItems.isEmpty() ? ItemStack.field_190927_a : requiredItems.get(0);
        if (entityMode) {
            this.launchEntity(this.target, icon, this.blockReader.getEntities().get(this.printingEntityIndex));
        } else if (AllBlocks.BELT.has(blockState)) {
            TileEntity te = this.blockReader.func_175625_s(this.currentPos.func_177971_a((Vec3i)this.schematicAnchor));
            blockState = this.stripBeltIfNotLast(blockState);
            if (te instanceof BeltTileEntity && AllBlocks.BELT.has(blockState)) {
                this.launchBelt(this.target, blockState, ((BeltTileEntity)te).beltLength);
            } else {
                this.launchBlock(this.target, icon, blockState, null);
            }
        } else {
            TileEntity tile;
            CompoundNBT data = null;
            if (AllTags.AllBlockTags.SAFE_NBT.matches(blockState) && (tile = this.blockReader.func_175625_s(this.target)) != null && !tile.func_183000_F()) {
                data = tile.func_189515_b(new CompoundNBT());
            }
            this.launchBlock(this.target, icon, blockState, data);
        }
        this.printerCooldown = (Integer)this.config().schematicannonDelay.get();
        this.fuelLevel = (float)((double)this.fuelLevel - this.getFuelUsageRate());
        this.sendUpdate = true;
        this.missingItem = null;
    }

    public BlockState stripBeltIfNotLast(BlockState blockState) {
        boolean isLastSegment = false;
        Direction facing = (Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)blockState.func_177229_b(BeltBlock.SLOPE));
        boolean positive = facing.func_176743_c() == Direction.AxisDirection.POSITIVE;
        boolean start = blockState.func_177229_b(BeltBlock.PART) == BeltPart.START;
        boolean end = blockState.func_177229_b(BeltBlock.PART) == BeltPart.END;
        switch (slope) {
            case DOWNWARD: {
                isLastSegment = start;
                break;
            }
            case UPWARD: {
                isLastSegment = end;
                break;
            }
            default: {
                boolean bl = isLastSegment = positive && end || !positive && start;
            }
        }
        if (!isLastSegment) {
            blockState = blockState.func_177229_b(BeltBlock.PART) == BeltPart.MIDDLE ? Blocks.field_150350_a.func_176223_P() : (BlockState)AllBlocks.SHAFT.getDefaultState().func_206870_a((IProperty)AbstractShaftBlock.AXIS, (Comparable)facing.func_176746_e().func_176740_k());
        }
        return blockState;
    }

    public double getFuelUsageRate() {
        return this.hasCreativeCrate ? 0.0 : (Double)this.config().schematicannonFuelUsage.get() / 100.0;
    }

    protected void initializePrinter(ItemStack blueprint) {
        if (!blueprint.func_77942_o()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicInvalid";
            this.sendUpdate = true;
            return;
        }
        if (!blueprint.func_77978_p().func_74767_n("Deployed")) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicNotPlaced";
            this.sendUpdate = true;
            return;
        }
        Template activeTemplate = SchematicItem.loadSchematic(blueprint);
        BlockPos anchor = NBTUtil.func_186861_c((CompoundNBT)blueprint.func_77978_p().func_74775_l("Anchor"));
        if (activeTemplate.func_186259_a().equals((Object)BlockPos.field_177992_a)) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicExpired";
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            this.inventory.setStackInSlot(1, new ItemStack((IItemProvider)AllItems.EMPTY_SCHEMATIC.get()));
            return;
        }
        if (!anchor.func_218141_a((Vec3i)this.func_174877_v(), 256.0)) {
            this.state = State.STOPPED;
            this.statusMsg = "targetOutsideRange";
            return;
        }
        this.schematicAnchor = anchor;
        this.blockReader = new SchematicWorld(this.schematicAnchor, this.field_145850_b);
        PlacementSettings settings = SchematicItem.getSettings(blueprint);
        activeTemplate.func_186253_b((IWorld)this.blockReader, this.schematicAnchor, settings);
        this.schematicLoaded = true;
        this.state = State.PAUSED;
        this.statusMsg = "ready";
        this.printingEntityIndex = -1;
        this.updateChecklist();
        this.sendUpdate = true;
        this.blocksToPlace += this.blocksPlaced;
        MutableBoundingBox bounds = this.blockReader.getBounds();
        this.currentPos = this.currentPos != null ? this.currentPos.func_177976_e() : new BlockPos(bounds.field_78897_a - 1, bounds.field_78895_b, bounds.field_78896_c);
    }

    protected ItemStack getItemForBlock(BlockState blockState) {
        Item item = BlockItem.field_179220_a.getOrDefault(blockState.func_177230_c(), Items.field_190931_a);
        return item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item);
    }

    protected boolean grabItemsFromAttachedInventories(ItemStack required, ItemRequirement.ItemUseType usage, boolean simulate) {
        if (this.hasCreativeCrate) {
            return true;
        }
        if (usage == ItemRequirement.ItemUseType.DAMAGE) {
            for (IItemHandler iItemHandler : this.attachedInventories) {
                for (int slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    ItemStack extractItem = iItemHandler.extractItem(slot, 1, true);
                    if (!ItemRequirement.validate(required, extractItem) || !extractItem.func_77984_f()) continue;
                    if (!simulate) {
                        ItemStack stack = iItemHandler.extractItem(slot, 1, false);
                        stack.func_196085_b(stack.func_77952_i() + 1);
                        if (stack.func_77952_i() <= stack.func_77958_k()) {
                            if (iItemHandler.getStackInSlot(slot).func_190926_b()) {
                                iItemHandler.insertItem(slot, stack, false);
                            } else {
                                ItemHandlerHelper.insertItem((IItemHandler)iItemHandler, (ItemStack)stack, (boolean)false);
                            }
                        }
                    }
                    return true;
                }
            }
        }
        boolean success = false;
        if (usage == ItemRequirement.ItemUseType.CONSUME) {
            int amountFound = 0;
            for (IItemHandler iItemHandler : this.attachedInventories) {
                if ((amountFound += ItemHelper.extract(iItemHandler, s -> ItemRequirement.validate(required, s), ItemHelper.ExtractionCountMode.UPTO, required.func_190916_E(), true).func_190916_E()) < required.func_190916_E()) continue;
                success = true;
                break;
            }
        }
        if (!simulate && success) {
            int amountFound = 0;
            for (IItemHandler iItemHandler : this.attachedInventories) {
                if ((amountFound += ItemHelper.extract(iItemHandler, s -> ItemRequirement.validate(required, s), ItemHelper.ExtractionCountMode.UPTO, required.func_190916_E(), false).func_190916_E()) >= required.func_190916_E()) break;
            }
        }
        return success;
    }

    protected void advanceCurrentPos() {
        List<Entity> entities = this.blockReader.getEntities();
        if (this.printingEntityIndex != -1) {
            ++this.printingEntityIndex;
            if (this.printingEntityIndex >= entities.size()) {
                this.finishedPrinting();
                return;
            }
            this.currentPos = entities.get(this.printingEntityIndex).func_180425_c().func_177973_b((Vec3i)this.schematicAnchor);
            return;
        }
        MutableBoundingBox bounds = this.blockReader.getBounds();
        this.currentPos = this.currentPos.func_177972_a(Direction.EAST);
        BlockPos posInBounds = this.currentPos.func_177982_a(-bounds.field_78897_a, -bounds.field_78895_b, -bounds.field_78896_c);
        if (posInBounds.func_177958_n() > bounds.func_78883_b()) {
            this.currentPos = new BlockPos(bounds.field_78897_a, this.currentPos.func_177956_o(), this.currentPos.func_177952_p() + 1).func_177976_e();
        }
        if (posInBounds.func_177952_p() > bounds.func_78880_d()) {
            this.currentPos = new BlockPos(this.currentPos.func_177958_n(), this.currentPos.func_177956_o() + 1, bounds.field_78896_c).func_177976_e();
        }
        if (this.currentPos.func_177956_o() > bounds.func_78882_c()) {
            this.printingEntityIndex = 0;
            if (entities.isEmpty()) {
                this.finishedPrinting();
                return;
            }
            this.currentPos = entities.get(0).func_180425_c().func_177973_b((Vec3i)this.schematicAnchor);
        }
    }

    public void finishedPrinting() {
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        this.inventory.setStackInSlot(1, new ItemStack((IItemProvider)AllItems.EMPTY_SCHEMATIC.get(), this.inventory.getStackInSlot(1).func_190916_E() + 1));
        this.state = State.STOPPED;
        this.statusMsg = "finished";
        this.resetPrinter();
        this.target = this.func_174877_v().func_177982_a(1, 0, 0);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), AllSoundEvents.SCHEMATICANNON_FINISH.get(), SoundCategory.BLOCKS, 1.0f, 0.7f);
        this.sendUpdate = true;
    }

    protected void resetPrinter() {
        this.schematicLoaded = false;
        this.schematicAnchor = null;
        this.currentPos = null;
        this.blockReader = null;
        this.missingItem = null;
        this.sendUpdate = true;
        this.printingEntityIndex = -1;
        this.schematicProgress = 0.0f;
        this.blocksPlaced = 0;
        this.blocksToPlace = 0;
    }

    protected boolean shouldPlace(BlockPos pos, BlockState state) {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockState toReplace = this.field_145850_b.func_180495_p(pos);
        boolean placingAir = state.func_177230_c().isAir(state, (IBlockReader)this.field_145850_b, pos);
        BlockState toReplaceOther = null;
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208139_an) && state.func_196959_b((IProperty)BlockStateProperties.field_208157_J) && state.func_177229_b((IProperty)BlockStateProperties.field_208139_an) == BedPart.FOOT) {
            toReplaceOther = this.field_145850_b.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208163_P) && state.func_177229_b((IProperty)BlockStateProperties.field_208163_P) == DoubleBlockHalf.LOWER) {
            toReplaceOther = this.field_145850_b.func_180495_p(pos.func_177984_a());
        }
        if (!this.field_145850_b.func_195588_v(pos)) {
            return false;
        }
        if (!this.field_145850_b.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (toReplace == state) {
            return false;
        }
        if (toReplace.func_185887_b((IBlockReader)this.field_145850_b, pos) == -1.0f || toReplaceOther != null && toReplaceOther.func_185887_b((IBlockReader)this.field_145850_b, pos) == -1.0f) {
            return false;
        }
        if (pos.func_218141_a((Vec3i)this.func_174877_v(), 2.0)) {
            return false;
        }
        if (!this.replaceTileEntities && (toReplace.hasTileEntity() || toReplaceOther != null && toReplaceOther.hasTileEntity())) {
            return false;
        }
        if (this.shouldIgnoreBlockState(state)) {
            return false;
        }
        if (this.replaceMode == 3) {
            return true;
        }
        if (this.replaceMode == 2 && !placingAir) {
            return true;
        }
        if (!(this.replaceMode != 1 || !state.func_215686_e((IBlockReader)this.blockReader, pos.func_177973_b((Vec3i)this.schematicAnchor)) && (toReplace.func_215686_e((IBlockReader)this.field_145850_b, pos) || toReplaceOther != null && toReplaceOther.func_215686_e((IBlockReader)this.field_145850_b, pos)) || placingAir)) {
            return true;
        }
        return this.replaceMode == 0 && !toReplace.func_215686_e((IBlockReader)this.field_145850_b, pos) && (toReplaceOther == null || !toReplaceOther.func_215686_e((IBlockReader)this.field_145850_b, pos)) && !placingAir;
    }

    protected boolean shouldIgnoreBlockState(BlockState state) {
        if (state.func_177230_c() == Blocks.field_189881_dj) {
            return true;
        }
        ItemRequirement requirement = ItemRequirement.of(state);
        if (requirement.isEmpty()) {
            return false;
        }
        if (requirement.isInvalid()) {
            return false;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208163_P) && state.func_177229_b((IProperty)BlockStateProperties.field_208163_P) == DoubleBlockHalf.UPPER) {
            return true;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208139_an) && state.func_177229_b((IProperty)BlockStateProperties.field_208139_an) == BedPart.HEAD) {
            return true;
        }
        return state.func_177230_c() instanceof PistonHeadBlock;
    }

    protected void tickFlyingBlocks() {
        LinkedList<LaunchedItem> toRemove = new LinkedList<LaunchedItem>();
        for (LaunchedItem b : this.flyingBlocks) {
            if (!b.update(this.field_145850_b)) continue;
            toRemove.add(b);
        }
        this.flyingBlocks.removeAll(toRemove);
    }

    protected void refillFuelIfPossible() {
        if (this.hasCreativeCrate) {
            return;
        }
        if ((double)(1.0f - this.fuelLevel + 0.0078125f) < this.getFuelAddedByGunPowder()) {
            return;
        }
        if (this.inventory.getStackInSlot(4).func_190926_b()) {
            return;
        }
        this.inventory.getStackInSlot(4).func_190918_g(1);
        this.fuelLevel = (float)((double)this.fuelLevel + this.getFuelAddedByGunPowder());
        this.sendUpdate = true;
    }

    public double getFuelAddedByGunPowder() {
        return (Double)this.config().schematicannonGunpowderWorth.get() / 100.0;
    }

    protected void tickPaperPrinter() {
        boolean outputFull;
        int BookInput = 2;
        int BookOutput = 3;
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        ItemStack paper = this.inventory.extractItem(BookInput, 1, true);
        boolean bl = outputFull = this.inventory.getStackInSlot(BookOutput).func_190916_E() == this.inventory.getSlotLimit(BookOutput);
        if (paper.func_190926_b() || outputFull) {
            if (this.bookPrintingProgress != 0.0f) {
                this.sendUpdate = true;
            }
            this.bookPrintingProgress = 0.0f;
            this.dontUpdateChecklist = false;
            return;
        }
        if (!this.schematicLoaded) {
            if (!blueprint.func_190926_b()) {
                this.initializePrinter(blueprint);
            }
            return;
        }
        if (this.bookPrintingProgress >= 1.0f) {
            this.bookPrintingProgress = 0.0f;
            if (!this.dontUpdateChecklist) {
                this.updateChecklist();
            }
            this.dontUpdateChecklist = true;
            this.inventory.extractItem(BookInput, 1, false);
            ItemStack stack = this.checklist.createItem();
            stack.func_190920_e(this.inventory.getStackInSlot(BookOutput).func_190916_E() + 1);
            this.inventory.setStackInSlot(BookOutput, stack);
            this.sendUpdate = true;
            return;
        }
        this.bookPrintingProgress += 0.05f;
        this.sendUpdate = true;
    }

    protected void launchBelt(BlockPos target, BlockState state, int length) {
        ++this.blocksPlaced;
        ItemStack connector = AllItems.BELT_CONNECTOR.asStack();
        this.flyingBlocks.add(new LaunchedItem.ForBelt(this.func_174877_v(), target, connector, state, length));
        this.playFiringSound();
    }

    protected void launchBlock(BlockPos target, ItemStack stack, BlockState state, @Nullable CompoundNBT data) {
        if (state.func_177230_c().isAir(state, (IBlockReader)this.field_145850_b, target)) {
            ++this.blocksPlaced;
        }
        this.flyingBlocks.add(new LaunchedItem.ForBlockState(this.func_174877_v(), target, stack, state, data));
        this.playFiringSound();
    }

    protected void launchEntity(BlockPos target, ItemStack stack, Entity entity) {
        ++this.blocksPlaced;
        this.flyingBlocks.add(new LaunchedItem.ForEntity(this.func_174877_v(), target, stack, entity));
        this.playFiringSound();
    }

    public void playFiringSound() {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), AllSoundEvents.SCHEMATICANNON_LAUNCH_BLOCK.get(), SoundCategory.BLOCKS, 0.1f, 1.1f);
    }

    public void sendToContainer(PacketBuffer buffer) {
        buffer.func_179255_a(this.func_174877_v());
        buffer.func_150786_a(this.func_189517_E_());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new SchematicannonContainer(id, inv, this);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().toString());
    }

    public void updateChecklist() {
        this.checklist.required.clear();
        this.checklist.damageRequired.clear();
        this.checklist.blocksNotLoaded = false;
        if (this.schematicLoaded) {
            this.blocksToPlace = this.blocksPlaced;
            for (BlockPos pos : this.blockReader.getAllPositions()) {
                ItemRequirement requirement;
                BlockState required = this.blockReader.func_180495_p(pos.func_177971_a((Vec3i)this.schematicAnchor));
                if (!this.func_145831_w().isAreaLoaded(pos.func_177971_a((Vec3i)this.schematicAnchor), 0)) {
                    this.checklist.warnBlockNotLoaded();
                    continue;
                }
                if (!this.shouldPlace(pos.func_177971_a((Vec3i)this.schematicAnchor), required) || (requirement = ItemRequirement.of(required)).isEmpty() || requirement.isInvalid()) continue;
                this.checklist.require(requirement);
                ++this.blocksToPlace;
            }
            for (Entity entity : this.blockReader.getEntities()) {
                ItemRequirement requirement = ItemRequirement.of(entity);
                if (requirement.isEmpty() || requirement.isInvalid()) continue;
                this.checklist.require(requirement);
            }
        }
        this.checklist.gathered.clear();
        for (IItemHandler inventory : this.attachedInventories) {
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack stackInSlot = inventory.getStackInSlot(slot);
                if (inventory.extractItem(slot, 1, true).func_190926_b()) continue;
                this.checklist.collect(stackInSlot);
            }
        }
        this.sendUpdate = true;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    public static enum State {
        STOPPED,
        PAUSED,
        RUNNING;

    }
}

