/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client.tools;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.tools.PlacementToolBase;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class DeployTool
extends PlacementToolBase {
    @Override
    public void init() {
        super.init();
        this.selectionRange = -1;
    }

    @Override
    public void updateSelection() {
        if (this.schematicHandler.isActive() && this.selectionRange == -1) {
            this.selectionRange = (int)(this.schematicHandler.getBounds().func_189972_c().func_72433_c() / 2.0);
            this.selectionRange = MathHelper.func_76125_a((int)this.selectionRange, (int)1, (int)100);
        }
        this.selectIgnoreBlocks = AllKeys.ACTIVATE_TOOL.isPressed();
        super.updateSelection();
    }

    @Override
    public void renderTool(MatrixStack ms, SuperRenderTypeBuffer buffer) {
        super.renderTool(ms, buffer);
        if (this.selectedPos == null) {
            return;
        }
        ms.func_227860_a_();
        float pt = Minecraft.func_71410_x().func_184121_ak();
        double x = MathHelper.func_219803_d((double)pt, (double)this.lastChasingSelectedPos.field_72450_a, (double)this.chasingSelectedPos.field_72450_a);
        double y = MathHelper.func_219803_d((double)pt, (double)this.lastChasingSelectedPos.field_72448_b, (double)this.chasingSelectedPos.field_72448_b);
        double z = MathHelper.func_219803_d((double)pt, (double)this.lastChasingSelectedPos.field_72449_c, (double)this.chasingSelectedPos.field_72449_c);
        SchematicTransformation transformation = this.schematicHandler.getTransformation();
        AxisAlignedBB bounds = this.schematicHandler.getBounds();
        Vec3d center = bounds.func_189972_c();
        Vec3d rotationOffset = transformation.getRotationOffset(true);
        int centerX = (int)center.field_72450_a;
        int centerZ = (int)center.field_72449_c;
        double xOrigin = bounds.func_216364_b() / 2.0;
        double zOrigin = bounds.func_216362_d() / 2.0;
        Vec3d origin = new Vec3d(xOrigin, 0.0, zOrigin);
        ms.func_227861_a_(x - (double)centerX, y, z - (double)centerZ);
        MatrixStacker.of(ms).translate(origin).translate(rotationOffset).rotateY(transformation.getCurrentRotation()).translateBack(rotationOffset).translateBack(origin);
        AABBOutline outline = this.schematicHandler.getOutline();
        outline.render(ms, buffer);
        outline.getParams().clearTextures();
        ms.func_227865_b_();
    }

    @Override
    public boolean handleMouseWheel(double delta) {
        if (!this.selectIgnoreBlocks) {
            return super.handleMouseWheel(delta);
        }
        this.selectionRange = (int)((double)this.selectionRange + delta);
        this.selectionRange = MathHelper.func_76125_a((int)this.selectionRange, (int)1, (int)100);
        return true;
    }

    @Override
    public boolean handleRightClick() {
        if (this.selectedPos == null) {
            return super.handleRightClick();
        }
        Vec3d center = this.schematicHandler.getBounds().func_189972_c();
        BlockPos target = this.selectedPos.func_177982_a(-((int)center.field_72450_a), 0, -((int)center.field_72449_c));
        ItemStack item = this.schematicHandler.getActiveSchematicItem();
        if (item != null) {
            item.func_77978_p().func_74757_a("Deployed", true);
            item.func_77978_p().func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)target));
        }
        this.schematicHandler.getTransformation().moveTo(target);
        this.schematicHandler.markDirty();
        this.schematicHandler.deploy();
        return true;
    }
}

