/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.packet;

import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ConfigureSchematicannonPacket
extends SimplePacketBase {
    private Option option;
    private boolean set;
    private BlockPos pos;

    public static ConfigureSchematicannonPacket setOption(BlockPos pos, Option option, boolean set) {
        ConfigureSchematicannonPacket packet = new ConfigureSchematicannonPacket(pos);
        packet.option = option;
        packet.set = set;
        return packet;
    }

    public ConfigureSchematicannonPacket(BlockPos pos) {
        this.pos = pos;
    }

    public ConfigureSchematicannonPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.option = Option.values()[buffer.readInt()];
        this.set = buffer.readBoolean();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.option.ordinal());
        buffer.writeBoolean(this.set);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            World world = player.field_70170_p;
            if (world == null || !world.func_195588_v(this.pos)) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (!(tileEntity instanceof SchematicannonTileEntity)) {
                return;
            }
            SchematicannonTileEntity te = (SchematicannonTileEntity)tileEntity;
            switch (this.option) {
                case DONT_REPLACE: 
                case REPLACE_ANY: 
                case REPLACE_EMPTY: 
                case REPLACE_SOLID: {
                    te.replaceMode = this.option.ordinal();
                    break;
                }
                case SKIP_MISSING: {
                    te.skipMissing = this.set;
                    break;
                }
                case SKIP_TILES: {
                    te.replaceTileEntities = this.set;
                    break;
                }
                case PLAY: {
                    te.state = SchematicannonTileEntity.State.RUNNING;
                    te.statusMsg = "running";
                    break;
                }
                case PAUSE: {
                    te.state = SchematicannonTileEntity.State.PAUSED;
                    te.statusMsg = "paused";
                    break;
                }
                case STOP: {
                    te.state = SchematicannonTileEntity.State.STOPPED;
                    te.statusMsg = "stopped";
                    break;
                }
            }
            te.sendUpdate = true;
        });
        context.get().setPacketHandled(true);
    }

    public static enum Option {
        DONT_REPLACE,
        REPLACE_SOLID,
        REPLACE_ANY,
        REPLACE_EMPTY,
        SKIP_MISSING,
        SKIP_TILES,
        PLAY,
        PAUSE,
        STOP;

    }
}

