/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.IBakedModel;
import org.apache.commons.lang3.tuple.Pair;

public class CustomBlockModels {
    private List<Pair<Supplier<? extends Block>, NonNullFunction<IBakedModel, ? extends IBakedModel>>> registered = new ArrayList<Pair<Supplier<? extends Block>, NonNullFunction<IBakedModel, ? extends IBakedModel>>>();
    private Map<Block, NonNullFunction<IBakedModel, ? extends IBakedModel>> customModels = new IdentityHashMap<Block, NonNullFunction<IBakedModel, ? extends IBakedModel>>();

    public void register(Supplier<? extends Block> entry, NonNullFunction<IBakedModel, ? extends IBakedModel> behaviour) {
        this.registered.add((Pair<Supplier<? extends Block>, NonNullFunction<IBakedModel, ? extends IBakedModel>>)Pair.of(entry, behaviour));
    }

    public void foreach(NonNullBiConsumer<Block, NonNullFunction<IBakedModel, ? extends IBakedModel>> consumer) {
        this.loadEntriesIfMissing();
        this.customModels.forEach(consumer);
    }

    private void loadEntriesIfMissing() {
        if (this.customModels.isEmpty()) {
            this.loadEntries();
        }
    }

    private void loadEntries() {
        this.customModels.clear();
        this.registered.forEach(p -> {
            Block key = (Block)((Supplier)p.getKey()).get();
            NonNullFunction<IBakedModel, ? extends IBakedModel> existingModel = this.customModels.get(key);
            if (existingModel != null) {
                this.customModels.put(key, ((NonNullFunction)p.getValue()).andThen(existingModel));
                return;
            }
            this.customModels.put(key, (NonNullFunction<IBakedModel, ? extends IBakedModel>)p.getValue());
        });
    }
}

