/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.collision;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.collision.ContinuousOBBCollider;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OBBCollider;
import com.simibubi.create.foundation.collision.OrientedBB;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class CollisionDebugger {
    public static AxisAlignedBB AABB = new AxisAlignedBB(BlockPos.field_177992_a.func_177981_b(10));
    public static OrientedBB OBB = new OrientedBB(new AxisAlignedBB(BlockPos.field_177992_a));
    public static Vec3d motion = Vec3d.field_186680_a;
    static ContinuousOBBCollider.ContinuousSeparationManifold seperation;
    static double angle;
    static AABBOutline outline;

    public static void onScroll(double delta) {
        angle += delta;
        angle = (int)angle;
        OBB.setRotation(new Matrix3d().asZRotation(AngleHelper.rad(angle)));
    }

    public static void render(MatrixStack ms, SuperRenderTypeBuffer buffer) {
        Vec3d asSeparationVec;
        ms.func_227860_a_();
        outline = new AABBOutline(OBB.getAsAxisAlignedBB());
        outline.getParams().withFaceTexture(seperation == null ? AllSpecialTextures.CHECKERED : null).colored(0xFFFFFF);
        if (seperation != null) {
            outline.getParams().lineWidth(0.015625f).colored(16737604);
        }
        MatrixStacker.of(ms).translate(CollisionDebugger.OBB.center);
        ms.func_227866_c_().func_227870_a_().func_226595_a_(CollisionDebugger.OBB.rotation.getAsMatrix4f());
        MatrixStacker.of(ms).translateBack(CollisionDebugger.OBB.center);
        outline.render(ms, buffer);
        ms.func_227865_b_();
        ms.func_227860_a_();
        if (seperation != null && (asSeparationVec = seperation.asSeparationVec(0.5)) != null) {
            outline.getParams().colored(6684484).lineWidth(0.03125f);
            MatrixStacker.of(ms).translate(asSeparationVec).translate(CollisionDebugger.OBB.center);
            ms.func_227866_c_().func_227870_a_().func_226595_a_(CollisionDebugger.OBB.rotation.getAsMatrix4f());
            MatrixStacker.of(ms).translateBack(CollisionDebugger.OBB.center);
            outline.render(ms, buffer);
        }
        ms.func_227865_b_();
    }

    public static void tick() {
        AABB = new AxisAlignedBB(BlockPos.field_177992_a.func_177981_b(60)).func_72317_d(0.5, 0.0, 0.5);
        motion = Vec3d.field_186680_a;
        RayTraceResult mouse = Minecraft.func_71410_x().field_71476_x;
        if (mouse != null && mouse.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult hit = (BlockRayTraceResult)mouse;
            OBB.setCenter(hit.func_216347_e());
            seperation = OBB.intersect(AABB, motion);
        }
        CreateClient.outliner.showAABB(AABB, AABB).withFaceTexture(seperation == null ? AllSpecialTextures.CHECKERED : null);
    }

    static void showDebugLine(Vec3d relativeStart, Vec3d relativeEnd, int color, String id, int offset) {
        Vec3d center = AABB.func_189972_c().func_72441_c(0.0, (double)(1.0f + (float)offset / 16.0f), 0.0);
        CreateClient.outliner.showLine(id + OBBCollider.checkCount, center.func_178787_e(relativeStart), center.func_178787_e(relativeEnd)).colored(color).lineWidth(0.03125f);
    }

    static {
        angle = 0.0;
    }
}

