/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new FluidStackIngredient();
    public List<FluidStack> matchingFluidStacks;
    protected int amountRequired;

    public static FluidIngredient fromTag(Tag<Fluid> tag, int amount) {
        FluidTagIngredient ingredient = new FluidTagIngredient();
        ingredient.tag = tag;
        ingredient.amountRequired = amount;
        return ingredient;
    }

    public static FluidIngredient fromFluid(Fluid fluid, int amount) {
        FluidStackIngredient ingredient = new FluidStackIngredient();
        ingredient.fluid = fluid;
        ingredient.amountRequired = amount;
        ingredient.fixFlowing();
        return ingredient;
    }

    public static FluidIngredient fromFluidStack(FluidStack fluidStack) {
        FluidStackIngredient ingredient = new FluidStackIngredient();
        ingredient.fluid = fluidStack.getFluid();
        ingredient.amountRequired = fluidStack.getAmount();
        ingredient.fixFlowing();
        if (fluidStack.hasTag()) {
            ingredient.tagToMatch = fluidStack.getTag();
        }
        return ingredient;
    }

    protected abstract boolean testInternal(FluidStack var1);

    protected abstract void readInternal(PacketBuffer var1);

    protected abstract void writeInternal(PacketBuffer var1);

    protected abstract void readInternal(JsonObject var1);

    protected abstract void writeInternal(JsonObject var1);

    protected abstract List<FluidStack> determineMatchingFluidStacks();

    public int getRequiredAmount() {
        return this.amountRequired;
    }

    public List<FluidStack> getMatchingFluidStacks() {
        if (this.matchingFluidStacks != null) {
            return this.matchingFluidStacks;
        }
        this.matchingFluidStacks = this.determineMatchingFluidStacks();
        return this.matchingFluidStacks;
    }

    @Override
    public boolean test(FluidStack t) {
        if (t == null) {
            throw new IllegalArgumentException("FluidStack cannot be null");
        }
        return this.testInternal(t);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this instanceof FluidTagIngredient);
        buffer.func_150787_b(this.amountRequired);
        this.writeInternal(buffer);
    }

    public static FluidIngredient read(PacketBuffer buffer) {
        boolean isTagIngredient = buffer.readBoolean();
        FluidIngredient ingredient = isTagIngredient ? new FluidTagIngredient() : new FluidStackIngredient();
        ingredient.amountRequired = buffer.func_150792_a();
        ingredient.readInternal(buffer);
        return ingredient;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        this.writeInternal(json);
        json.addProperty("amount", (Number)this.amountRequired);
        return json;
    }

    public static boolean isFluidIngredient(@Nullable JsonElement je) {
        if (je == null || je.isJsonNull()) {
            return false;
        }
        if (!je.isJsonObject()) {
            return false;
        }
        JsonObject json = je.getAsJsonObject();
        if (json.has("fluidTag")) {
            return true;
        }
        return json.has("fluid");
    }

    public static FluidIngredient deserialize(@Nullable JsonElement je) {
        if (!FluidIngredient.isFluidIngredient(je)) {
            throw new JsonSyntaxException("Invalid fluid ingredient: " + Objects.toString(je));
        }
        JsonObject json = je.getAsJsonObject();
        FluidIngredient ingredient = json.has("fluidTag") ? new FluidTagIngredient() : new FluidStackIngredient();
        ingredient.readInternal(json);
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Fluid ingredient has to define an amount");
        }
        ingredient.amountRequired = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
        return ingredient;
    }

    public static class FluidTagIngredient
    extends FluidIngredient {
        protected Tag<Fluid> tag;

        @Override
        protected boolean testInternal(FluidStack t) {
            if (this.tag == null) {
                for (FluidStack accepted : this.getMatchingFluidStacks()) {
                    if (!accepted.getFluid().func_207187_a(t.getFluid())) continue;
                    return true;
                }
            }
            return t.getFluid().func_207185_a(this.tag);
        }

        @Override
        protected void readInternal(PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            this.matchingFluidStacks = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.matchingFluidStacks.add(buffer.readFluidStack());
            }
        }

        @Override
        protected void writeInternal(PacketBuffer buffer) {
            List<FluidStack> matchingFluidStacks = this.getMatchingFluidStacks();
            buffer.func_150787_b(matchingFluidStacks.size());
            matchingFluidStacks.stream().forEach(arg_0 -> ((PacketBuffer)buffer).writeFluidStack(arg_0));
        }

        @Override
        protected void readInternal(JsonObject json) {
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluidTag"));
            this.tag = FluidTags.func_226157_a_().func_199910_a(id);
            if (this.tag == null) {
                throw new JsonSyntaxException("Unknown fluid tag '" + id + "'");
            }
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("fluidTag", this.tag.func_199886_b().toString());
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return this.tag.func_199885_a().stream().map(f -> {
                if (f instanceof FlowingFluid) {
                    return ((FlowingFluid)f).func_210198_f();
                }
                return f;
            }).distinct().map(f -> new FluidStack(f, this.amountRequired)).collect(Collectors.toList());
        }
    }

    public static class FluidStackIngredient
    extends FluidIngredient {
        protected Fluid fluid;
        protected CompoundNBT tagToMatch = new CompoundNBT();

        void fixFlowing() {
            if (this.fluid instanceof FlowingFluid) {
                this.fluid = ((FlowingFluid)this.fluid).func_210198_f();
            }
        }

        @Override
        protected boolean testInternal(FluidStack t) {
            if (!t.getFluid().func_207187_a(this.fluid)) {
                return false;
            }
            if (this.tagToMatch.isEmpty()) {
                return true;
            }
            CompoundNBT tag = t.getOrCreateTag();
            return tag.func_74737_b().func_197643_a(this.tagToMatch).equals((Object)tag);
        }

        @Override
        protected void readInternal(PacketBuffer buffer) {
            this.fluid = (Fluid)buffer.readRegistryId();
            this.tagToMatch = buffer.func_150793_b();
        }

        @Override
        protected void writeInternal(PacketBuffer buffer) {
            buffer.writeRegistryId((IForgeRegistryEntry)this.fluid);
            buffer.func_150786_a(this.tagToMatch);
        }

        @Override
        protected void readInternal(JsonObject json) {
            FluidStack stack = FluidHelper.deserializeFluidStack(json);
            this.fluid = stack.getFluid();
            this.tagToMatch = stack.getOrCreateTag();
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("fluid", this.fluid.getRegistryName().toString());
            json.add("nbt", new JsonParser().parse(this.tagToMatch.toString()));
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return ImmutableList.of((Object)(this.tagToMatch.isEmpty() ? new FluidStack(this.fluid, this.amountRequired) : new FluidStack(this.fluid, this.amountRequired, this.tagToMatch)));
        }
    }
}

