/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.tools.Tools;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ToolSelectionScreen
extends Screen {
    public final String scrollToCycle = Lang.translate("gui.toolmenu.cycle", new Object[0]);
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<Tools> tools;
    protected Consumer<Tools> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    protected int w;
    protected int h;

    public ToolSelectionScreen(List<Tools> tools, Consumer<Tools> callback) {
        super((ITextComponent)new StringTextComponent("Tool Selection"));
        this.minecraft = Minecraft.func_71410_x();
        this.tools = tools;
        this.callback = callback;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(Tools tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(float partialTicks) {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        int x = (mainWindow.func_198107_o() - this.w) / 2 + 15;
        int y = mainWindow.func_198087_p() - this.h - 75;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)(-this.yOffset), (float)(this.focused ? 100.0f : 0.0f));
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.focused ? 0.875f : 0.5f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
        ToolSelectionScreen.blit((int)(x - 15), (int)y, (float)gray.startX, (float)gray.startY, (int)this.w, (int)this.h, (int)gray.width, (int)gray.height);
        float toolTipAlpha = this.yOffset / 10.0f;
        FontRenderer font = this.minecraft.field_71466_p;
        List<String> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            RenderSystem.color4f((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            ToolSelectionScreen.blit((int)(x - 15), (int)(y + 33), (float)gray.startX, (float)gray.startY, (int)this.w, (int)(this.h + 22), (int)gray.width, (int)gray.height);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                this.drawString(font, toolTip.get(0), x - 10, y + 38, 0xEEEEEE + stringAlphaComponent);
            }
            if (toolTip.size() > 1) {
                this.drawString(font, toolTip.get(1), x - 10, y + 50, 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 2) {
                this.drawString(font, toolTip.get(2), x - 10, y + 60, 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 3) {
                this.drawString(font, toolTip.get(3), x - 10, y + 72, 0xCCCCDD + stringAlphaComponent);
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.getBoundKey();
            int width = this.minecraft.func_228018_at_().func_198107_o();
            if (!this.focused) {
                this.drawCenteredString(this.minecraft.field_71466_p, Lang.translate("gui.toolmenu.focusKey", keyName), width / 2, y - 10, 0xCCDDFF);
            } else {
                this.drawCenteredString(this.minecraft.field_71466_p, this.scrollToCycle, width / 2, y - 10, 0xCCDDFF);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            RenderSystem.pushMatrix();
            float f = alpha = this.focused ? 1.0f : 0.2f;
            if (i == this.selection) {
                RenderSystem.translatef((float)0.0f, (float)-10.0f, (float)0.0f);
                this.drawCenteredString(this.minecraft.field_71466_p, this.tools.get(i).getDisplayName(), x + i * 50 + 24, y + 28, 0xCCDDFF);
                alpha = 1.0f;
            }
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().draw((AbstractGui)this, x + i * 50 + 16, y + 12);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().draw((AbstractGui)this, x + i * 50 + 16, y + 11);
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(float partialTicks) {
        this.draw(partialTicks);
    }

    public void onClose() {
        this.callback.accept(this.tools.get(this.selection));
    }
}

