/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.base.Strings;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.curiosities.tools.AllToolTiers;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.WipScription;
import com.simibubi.create.foundation.utility.Lang;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.MinecraftForgeClient;

public class TooltipHelper {
    public static final int maxWidthPerLine = 200;
    public static final Map<String, ItemDescription> cachedTooltips = new HashMap<String, ItemDescription>();
    public static com.mojang.bridge.game.Language cachedLanguage;
    private static boolean gogglesMode;
    private static final Map<Item, Supplier<String>> tooltipReferrals;

    public static String holdShift(ItemDescription.Palette color, boolean highlighted) {
        TextFormatting colorFormat = highlighted ? color.hColor : color.color;
        return TextFormatting.DARK_GRAY + Lang.translate("tooltip.holdKey", colorFormat + Lang.translate("tooltip.keyShift", new Object[0]) + TextFormatting.DARK_GRAY);
    }

    public static void addHint(List<String> tooltip, String hintKey, Object ... messageParams) {
        String spacing = "    ";
        tooltip.add(spacing + TextFormatting.GOLD + Lang.translate(hintKey + ".title", new Object[0]));
        String hint = Lang.translate(hintKey, new Object[0]);
        List<String> cutString = TooltipHelper.cutString(spacing + hint, TextFormatting.GRAY, TextFormatting.WHITE);
        for (int i = 0; i < cutString.size(); ++i) {
            tooltip.add((i == 0 ? "" : spacing) + cutString.get(i));
        }
    }

    public static void referTo(IItemProvider item, Supplier<? extends IItemProvider> itemWithTooltip) {
        tooltipReferrals.put(item.func_199767_j(), () -> ((IItemProvider)itemWithTooltip.get()).func_199767_j().func_77658_a());
    }

    public static void referTo(IItemProvider item, String string) {
        tooltipReferrals.put(item.func_199767_j(), () -> string);
    }

    public static List<String> cutString(String s, TextFormatting defaultColor, TextFormatting highlightColor) {
        return TooltipHelper.cutString(s, defaultColor, highlightColor, 0);
    }

    public static List<String> cutString(String s, TextFormatting defaultColor, TextFormatting highlightColor, int indent) {
        String markedUp = s.replaceAll("_([^_]+)_", highlightColor + "$1" + defaultColor);
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftForgeClient.getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.func_78256_a(word);
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        String lineStart = Strings.repeat((String)" ", (int)indent);
        ArrayList<String> formattedLines = new ArrayList<String>(lines.size());
        String format = defaultColor.toString();
        for (String line : lines) {
            String formattedLine = format + lineStart + line;
            formattedLines.add(formattedLine);
            format = TextFormatting.func_211164_a((String)formattedLine);
        }
        return formattedLines;
    }

    private static void checkLocale() {
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (cachedLanguage != currentLanguage) {
            cachedTooltips.clear();
            cachedLanguage = currentLanguage;
        }
    }

    public static boolean hasTooltip(ItemStack stack, PlayerEntity player) {
        String key;
        TooltipHelper.checkLocale();
        boolean hasGlasses = AllItems.GOGGLES.isIn(player.func_184582_a(EquipmentSlotType.HEAD));
        if (hasGlasses != gogglesMode) {
            gogglesMode = hasGlasses;
            cachedTooltips.clear();
        }
        if (cachedTooltips.containsKey(key = TooltipHelper.getTooltipTranslationKey(stack))) {
            return cachedTooltips.get(key) != ItemDescription.MISSING;
        }
        return TooltipHelper.findTooltip(stack);
    }

    public static ItemDescription getTooltip(ItemStack stack) {
        ItemDescription itemDescription;
        TooltipHelper.checkLocale();
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (cachedTooltips.containsKey(key) && (itemDescription = cachedTooltips.get(key)) != ItemDescription.MISSING) {
            return itemDescription;
        }
        return null;
    }

    private static boolean findTooltip(ItemStack stack) {
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (I18n.func_188566_a((String)key)) {
            cachedTooltips.put(key, TooltipHelper.buildToolTip(key, stack));
            return true;
        }
        cachedTooltips.put(key, ItemDescription.MISSING);
        return false;
    }

    private static ItemDescription buildToolTip(String translationKey, ItemStack stack) {
        int i;
        BlockItem item;
        AllSections module = AllSections.of(stack);
        if (I18n.func_135052_a((String)translationKey, (Object[])new Object[0]).equals("WIP")) {
            return new WipScription(module.getTooltipPalette());
        }
        ItemDescription tooltip = new ItemDescription(module.getTooltipPalette());
        String summaryKey = translationKey + ".summary";
        if (I18n.func_188566_a((String)summaryKey)) {
            tooltip = tooltip.withSummary(I18n.func_135052_a((String)summaryKey, (Object[])new Object[0]));
        }
        if (stack.func_77973_b() instanceof BlockItem && ((item = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof IRotate || item.func_179223_d() instanceof EngineBlock)) {
            tooltip = tooltip.withKineticStats(item.func_179223_d());
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!I18n.func_188566_a((String)conditionKey)) break;
            tooltip.withBehaviour(I18n.func_135052_a((String)conditionKey, (Object[])new Object[0]), I18n.func_135052_a((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!I18n.func_188566_a((String)controlKey)) break;
            tooltip.withControl(I18n.func_135052_a((String)controlKey, (Object[])new Object[0]), I18n.func_135052_a((String)actionKey, (Object[])new Object[0]));
        }
        return tooltip.createTabs();
    }

    public static String getTooltipTranslationKey(ItemStack stack) {
        TieredItem tieredItem;
        Item item = stack.func_77973_b();
        if (item instanceof TieredItem && (tieredItem = (TieredItem)item).func_200891_e() instanceof AllToolTiers) {
            AllToolTiers allToolTiers = (AllToolTiers)tieredItem.func_200891_e();
            return "tool.create." + Lang.asId(allToolTiers.name()) + ".tooltip";
        }
        if (tooltipReferrals.containsKey(item)) {
            return tooltipReferrals.get(item).get() + ".tooltip";
        }
        return item.func_77667_c(stack) + ".tooltip";
    }

    static {
        tooltipReferrals = new HashMap<Item, Supplier<String>>();
    }
}

