/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity;

import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class SmartTileEntity
extends SyncedTileEntity
implements ITickableTileEntity {
    private Map<BehaviourType<?>, TileEntityBehaviour> behaviours = new HashMap();
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    private int lazyTickRate;
    private int lazyTickCounter;

    public SmartTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setLazyTickRate(10);
        ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
        this.addBehaviours(list);
        list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
    }

    public abstract void addBehaviours(List<TileEntityBehaviour> var1);

    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
    }

    public void func_73660_a() {
        if (!this.initialized && this.func_145830_o()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.behaviours.values().forEach(TileEntityBehaviour::tick);
    }

    public void initialize() {
        this.behaviours.values().forEach(TileEntityBehaviour::initialize);
        this.lazyTick();
    }

    public final CompoundNBT func_189515_b(CompoundNBT compound) {
        this.write(compound, false);
        return compound;
    }

    @Override
    public final CompoundNBT writeToClient(CompoundNBT compound) {
        this.write(compound, true);
        return compound;
    }

    @Override
    public final void readClientUpdate(CompoundNBT tag) {
        this.read(tag, true);
    }

    public final void func_145839_a(CompoundNBT tag) {
        this.read(tag, false);
    }

    protected void read(CompoundNBT compound, boolean clientPacket) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
            this.addBehavioursDeferred(list);
            list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
        }
        super.func_145839_a(compound);
        this.behaviours.values().forEach(tb -> tb.read(compound, clientPacket));
    }

    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.func_189515_b(compound);
        this.behaviours.values().forEach(tb -> tb.write(compound, clientPacket));
    }

    public void func_145843_s() {
        this.forEachBehaviour(TileEntityBehaviour::remove);
        super.func_145843_s();
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void lazyTick() {
    }

    protected void forEachBehaviour(Consumer<TileEntityBehaviour> action) {
        this.behaviours.values().forEach(action);
    }

    protected void attachBehaviourLate(TileEntityBehaviour behaviour) {
        this.behaviours.put(behaviour.getType(), behaviour);
        behaviour.initialize();
    }

    protected void removeBehaviour(BehaviourType<?> type) {
        TileEntityBehaviour remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.remove();
        }
    }

    public <T extends TileEntityBehaviour> T getBehaviour(BehaviourType<T> type) {
        if (this.behaviours.containsKey(type)) {
            return (T)this.behaviours.get(type);
        }
        return null;
    }

    protected boolean isItemHandlerCap(Capability<?> cap) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    protected boolean isFluidHandlerCap(Capability<?> cap) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }
}

