/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace.client.jei;

import com.github.commoble.jumbofurnace.JumboFurnace;
import com.github.commoble.jumbofurnace.JumboFurnaceObjects;
import com.github.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class JumboSmeltingCategory
implements IRecipeCategory<JumboFurnaceRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("jumbofurnace", "jumbo_smelting");
    public static final ResourceLocation JEI_RECIPE_TEXTURE = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic staticFlame;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableStatic backgroundFlame;

    public JumboSmeltingCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)JumboFurnaceObjects.JEI_DUMMY));
        this.background = helper.createDrawable(JEI_RECIPE_TEXTURE, 0, 60, 116, 54);
        this.localizedName = I18n.func_135052_a((String)"gui.jumbofurnace.category.jumbo_smelting", (Object[])new Object[0]);
        this.arrow = helper.drawableBuilder(JEI_RECIPE_TEXTURE, 82, 128, 24, 17).buildAnimated(JumboFurnace.SERVER_CONFIG.jumboFurnaceCookTime.get().intValue(), IDrawableAnimated.StartDirection.LEFT, false);
        this.staticFlame = helper.createDrawable(JEI_RECIPE_TEXTURE, 82, 114, 14, 14);
        this.animatedFlame = helper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.backgroundFlame = helper.createDrawable(JEI_RECIPE_TEXTURE, 1, 134, 14, 14);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends JumboFurnaceRecipe> getRecipeClass() {
        return JumboFurnaceRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(JumboFurnaceRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(JumboFurnaceRecipe recipe, double mouseX, double mouseY) {
        this.backgroundFlame.draw(66, 38);
        this.animatedFlame.draw(66, 38);
        this.arrow.draw(60, 18);
        float experience = recipe.experience;
        if (experience > 0.0f) {
            String experienceString = I18n.func_135052_a((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_211126_b(experienceString, (float)(this.background.getWidth() - stringWidth), 0.0f, -8355712);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, JumboFurnaceRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputID = row * 3 + column + 1;
                guiItemStacks.init(inputID, true, column * 18, row * 18);
            }
        }
        guiItemStacks.set(ingredients);
    }
}

