/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace.jumbo_furnace;

import com.github.commoble.jumbofurnace.JumboFurnaceObjects;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceContainer;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreTileEntity;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceOutputSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.network.NetworkHooks;

public class JumboFurnaceBlock
extends Block {
    public static final IntegerProperty X = IntegerProperty.func_177719_a((String)"x", (int)0, (int)2);
    public static final IntegerProperty Y = IntegerProperty.func_177719_a((String)"y", (int)0, (int)2);
    public static final IntegerProperty Z = IntegerProperty.func_177719_a((String)"z", (int)0, (int)2);
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;

    public JumboFurnaceBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)X, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)Y, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)Z, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{X, Y, Z, LIT});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.isCore(state) ? JumboFurnaceObjects.CORE_TE_TYPE.func_200968_a() : JumboFurnaceObjects.EXTERIOR_TE_TYPE.func_200968_a();
    }

    @Deprecated
    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockPos corePos = this.getCorePos(state, pos);
        TileEntity te = world.func_175625_s(corePos);
        if (te instanceof JumboFurnaceCoreTileEntity) {
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                JumboFurnaceCoreTileEntity core = (JumboFurnaceCoreTileEntity)te;
                IContainerProvider provider = JumboFurnaceContainer.getServerContainerProvider(core, pos);
                SimpleNamedContainerProvider namedProvider = new SimpleNamedContainerProvider(provider, JumboFurnaceContainer.TITLE);
                NetworkHooks.openGui((ServerPlayerEntity)serverPlayer, (INamedContainerProvider)namedProvider);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, corePos, player, handIn, hit);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof JumboFurnaceCoreTileEntity) {
                JumboFurnaceCoreTileEntity core = (JumboFurnaceCoreTileEntity)te;
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.5;
                double z = (double)pos.func_177952_p() + 0.5;
                float experience = 0.0f;
                for (int i = 0; i < 9; ++i) {
                    drops.add(core.input.getStackInSlot(i));
                    drops.add(core.fuel.getStackInSlot(i));
                    drops.add(core.output.getStackInSlot(i));
                    experience += core.output.storedExperience[i];
                }
                for (ItemStack drop : drops) {
                    InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)drop);
                }
                PlayerEntity player = world.func_217365_a(x, y, z);
                if (player != null) {
                    JumboFurnaceOutputSlot.spawnExpOrbs(player, experience);
                }
            }
            this.destroyNextBlockPos(world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public void destroyNextBlockPos(World world, BlockState state, BlockPos pos) {
        int zIndex;
        int nextZIndex;
        int yIndex;
        int nextYIndex;
        int xIndex;
        int nextXIndex;
        BlockPos nextPos;
        BlockState nextState;
        if (state.func_196959_b((IProperty)X) && state.func_196959_b((IProperty)Y) && state.func_196959_b((IProperty)Z) && (nextState = world.func_180495_p(nextPos = pos.func_177982_a((nextXIndex = ((xIndex = ((Integer)state.func_177229_b((IProperty)X)).intValue()) + 1) % 3) - xIndex, (nextYIndex = xIndex == 2 ? (yIndex + 1) % 3 : yIndex) - (yIndex = ((Integer)state.func_177229_b((IProperty)Y)).intValue()), (nextZIndex = xIndex == 2 && yIndex == 2 ? (zIndex + 1) % 3 : zIndex) - (zIndex = ((Integer)state.func_177229_b((IProperty)Z)).intValue())))).func_177230_c() == this) {
            world.func_175655_b(nextPos, true);
        }
    }

    public BlockPos getCorePos(BlockState exteriorState, BlockPos exteriorPos) {
        int xOff = exteriorState.func_196959_b((IProperty)X) ? 1 - (Integer)exteriorState.func_177229_b((IProperty)X) : 0;
        int yOff = exteriorState.func_196959_b((IProperty)Y) ? 1 - (Integer)exteriorState.func_177229_b((IProperty)Y) : 0;
        int zOff = exteriorState.func_196959_b((IProperty)Z) ? 1 - (Integer)exteriorState.func_177229_b((IProperty)Z) : 0;
        return exteriorPos.func_177982_a(xOff, yOff, zOff);
    }

    public boolean isCore(BlockState state) {
        return state.func_196959_b((IProperty)X) && state.func_196959_b((IProperty)Y) && state.func_196959_b((IProperty)Z) && (Integer)state.func_177229_b((IProperty)X) == 1 && (Integer)state.func_177229_b((IProperty)Y) == 1 && (Integer)state.func_177229_b((IProperty)Z) == 1;
    }

    public List<BlockSnapshot> getStatesForFurnace(IWorld world, BlockPos corePos) {
        ArrayList<BlockSnapshot> snapshots = new ArrayList<BlockSnapshot>(27);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    BlockState state = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)X, (Comparable)Integer.valueOf(x))).func_206870_a((IProperty)Y, (Comparable)Integer.valueOf(y))).func_206870_a((IProperty)Z, (Comparable)Integer.valueOf(z));
                    BlockPos pos = corePos.func_177982_a(x - 1, y - 1, z - 1);
                    BlockSnapshot snapshot = new BlockSnapshot(world, pos, state);
                    snapshots.add(snapshot);
                }
            }
        }
        return snapshots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            Direction direction;
            double x = (double)pos.func_177958_n() + 0.5;
            double y = pos.func_177956_o();
            double z = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a(x, y, z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if ((direction = this.getSmelterHoleDirection(state)) != null) {
                Direction.Axis direction$axis = direction.func_176740_k();
                double orthagonalOffset = rand.nextDouble() * 0.6 - 0.3;
                double xOff = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : orthagonalOffset;
                double yOff = rand.nextDouble() * 6.0 / 16.0;
                double zOff = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : orthagonalOffset;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xOff, y + yOff, z + zOff, 0.0, 0.0, 0.0);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + xOff, y + yOff, z + zOff, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public Direction getSmelterHoleDirection(BlockState state) {
        if (state.func_196959_b((IProperty)X) && state.func_196959_b((IProperty)Y) && state.func_196959_b((IProperty)Z)) {
            int y = (Integer)state.func_177229_b((IProperty)Y);
            if (y == 1) {
                int x = (Integer)state.func_177229_b((IProperty)X);
                int z = (Integer)state.func_177229_b((IProperty)Z);
                if (x == 1 && z == 0) {
                    return Direction.NORTH;
                }
                if (x == 1 && z == 2) {
                    return Direction.SOUTH;
                }
                if (x == 0 && z == 1) {
                    return Direction.WEST;
                }
                if (x == 2 && z == 1) {
                    return Direction.EAST;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (state.func_196959_b((IProperty)X) && state.func_196959_b((IProperty)Z)) {
            int x = (Integer)state.func_177229_b((IProperty)X);
            int z = (Integer)state.func_177229_b((IProperty)Z);
            switch (rot) {
                case NONE: {
                    return state;
                }
                case CLOCKWISE_90: {
                    return (BlockState)((BlockState)state.func_206870_a((IProperty)X, (Comparable)Integer.valueOf(2 - z))).func_206870_a((IProperty)Z, (Comparable)Integer.valueOf(x));
                }
                case CLOCKWISE_180: {
                    return (BlockState)((BlockState)state.func_206870_a((IProperty)X, (Comparable)Integer.valueOf(2 - x))).func_206870_a((IProperty)Z, (Comparable)Integer.valueOf(2 - z));
                }
                case COUNTERCLOCKWISE_90: {
                    return (BlockState)((BlockState)state.func_206870_a((IProperty)X, (Comparable)Integer.valueOf(z))).func_206870_a((IProperty)Z, (Comparable)Integer.valueOf(2 - x));
                }
            }
            return state;
        }
        return super.func_185499_a(state, rot);
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (state.func_196959_b((IProperty)X) && state.func_196959_b((IProperty)Z)) {
            switch (mirror) {
                case NONE: {
                    return state;
                }
                case LEFT_RIGHT: {
                    return (BlockState)state.func_206870_a((IProperty)Z, (Comparable)Integer.valueOf(2 - (Integer)state.func_177229_b((IProperty)Z)));
                }
                case FRONT_BACK: {
                    return (BlockState)state.func_206870_a((IProperty)X, (Comparable)Integer.valueOf(2 - (Integer)state.func_177229_b((IProperty)X)));
                }
            }
            return state;
        }
        return super.func_185471_a(state, mirror);
    }
}

