/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace.jumbo_furnace;

import com.github.commoble.jumbofurnace.JumboFurnaceObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MultiBlockHelper {
    public static final List<BlockSnapshot> NO_SNAPSHOTS = ImmutableList.of();

    public static List<BlockSnapshot> getJumboFurnaceStates(IWorld world, BlockPos placePos, BlockState againstState, Entity entity) {
        return MultiBlockHelper.get3x3CubeAround(placePos).filter(pos -> MultiBlockHelper.canJumboFurnaceFormAt(world, pos, placePos)).map(pos -> MultiBlockHelper.getSnapshotsIfPermitted(world, pos, againstState, entity)).filter(list -> !list.isEmpty()).findFirst().orElse((List)ImmutableList.of());
    }

    public static boolean canJumboFurnaceFormAt(IWorld world, BlockPos corePos, BlockPos placePos) {
        return MultiBlockHelper.get3x3CubeAround(corePos).allMatch(pos -> pos.equals((Object)placePos) || world.func_180495_p(pos).func_177230_c() == Blocks.field_150460_al);
    }

    public static Stream<BlockPos> get3x3CubeAround(BlockPos pos) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1));
    }

    public static List<BlockSnapshot> getSnapshotsIfPermitted(IWorld world, BlockPos corePos, BlockState againstState, Entity placer) {
        List<BlockSnapshot> snapshots = JumboFurnaceObjects.BLOCK.getStatesForFurnace(world, corePos);
        return MultiBlockHelper.doesPlayerHavePermissionToMakeJumboFurnace(snapshots, againstState, placer) ? snapshots : NO_SNAPSHOTS;
    }

    public static boolean doesPlayerHavePermissionToMakeJumboFurnace(List<BlockSnapshot> snapshots, BlockState placedAgainst, Entity entity) {
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(snapshots, placedAgainst, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }
}

