/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;

public class SortButton
extends Button {
    private final ISortButton button;
    private final List<String> tooltipLines = Lists.newArrayList();

    public SortButton(int x, int y, ISortButton button, Button.IPressable onPress) {
        super(x, y, 20, 20, "", onPress);
        this.button = button;
        this.tooltipLines.add(I18n.func_135052_a((String)this.button.getTooltip(), (Object[])new Object[0]));
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        int texY = this.button.getIconTextureY();
        if (!this.active) {
            texY += 40;
        } else if (this.isHovered) {
            texY += 20;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.button.getIcon());
        this.blit(this.x, this.y, this.button.getIconTextureX(), texY, this.width, this.height);
    }

    public List<String> getTooltipLines() {
        return this.tooltipLines;
    }

    public Comparator<FoodRecipeWithStatus> getComparator(PlayerEntity player) {
        return this.button.getComparator(player);
    }
}

