/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.network.PacketHandler;

public interface ITetraBlock {
    @OnlyIn(value=Dist.CLIENT)
    default public void clientInit() {
    }

    default public void init(PacketHandler packetHandler) {
    }

    public boolean hasItem();

    default public void registerItem(IForgeRegistry<Item> registry) {
        if (this instanceof Block) {
            this.registerItem(registry, (Block)this);
        }
    }

    default public void registerItem(IForgeRegistry<Item> registry, Block block) {
        Item item = (Item)new BlockItem(block, new Item.Properties().func_200916_a((ItemGroup)TetraItemGroup.instance)).setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
    }

    default public boolean canProvideCapabilities(World world, BlockPos pos, BlockPos targetPos) {
        return false;
    }

    default public Collection<Capability> getCapabilities(World world, BlockPos pos, BlockState blockState) {
        return Collections.emptyList();
    }

    default public int getCapabilityLevel(World world, BlockPos pos, BlockState blockState, Capability capability) {
        return -1;
    }

    default public ItemStack onCraftConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, Capability requiredCapability, int requiredLevel, boolean consumeResources) {
        return null;
    }

    default public ItemStack onActionConsumeCapability(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, Capability requiredCapability, int requiredLevel, boolean consumeResources) {
        return null;
    }
}

