/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.forged.hammer.EnumHammerEffect;
import se.mickelus.tetra.blocks.forged.hammer.EnumHammerPlate;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;

public class HammerBaseTile
extends TileEntity {
    @ObjectHolder(value="tetra:hammer_base")
    public static TileEntityType<HammerBaseTile> type;
    private static final String slotsKey = "slots";
    private static final String indexKey = "slot";
    private ItemStack[] slots = new ItemStack[2];

    public HammerBaseTile() {
        super(type);
    }

    public boolean hasEffect(EnumHammerEffect effect) {
        return HammerBaseBlock.hasEffect(this.field_145850_b, this.func_195044_w(), effect);
    }

    public int getHammerLevel() {
        return this.hasEffect(EnumHammerEffect.OVERCHARGED) ? 5 : 4;
    }

    public boolean isFueled() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.getCellFuel(i) > 0) continue;
            return false;
        }
        return true;
    }

    public void consumeFuel() {
        int fuelUsage = this.fuelUsage();
        for (int i = 0; i < this.slots.length; ++i) {
            this.consumeFuel(i, fuelUsage);
        }
        this.applyConsumeEffect();
    }

    public void consumeFuel(int index, int amount) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].func_77973_b() instanceof ItemCellMagmatic) {
            ItemCellMagmatic item = (ItemCellMagmatic)this.slots[index].func_77973_b();
            item.drainCharge(this.slots[index], amount);
            if (item.getCharge(this.slots[index]) <= 0) {
                BooleanProperty prop = index == 0 ? HammerBaseBlock.propCell1Charged : HammerBaseBlock.propCell2Charged;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)prop, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private void applyConsumeEffect() {
        Direction facing = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)HammerBaseBlock.propFacing);
        Vec3d pos = new Vec3d((Vec3i)this.func_174877_v());
        pos = pos.func_72441_c(0.5, 0.5, 0.5);
        Vec3d oppositePos = pos.func_178787_e(new Vec3d(facing.func_176734_d().func_176730_m()).func_186678_a(0.55));
        pos = pos.func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a(0.55));
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasEffect(EnumHammerEffect.OVERCHARGED)) {
                this.spawnParticle((IParticleData)ParticleTypes.field_197622_o, new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, -0.9, 0.5), 15, 0.1f);
            }
            if (this.hasEffect(EnumHammerEffect.LEAKY)) {
                int countCell0 = this.field_145850_b.field_73012_v.nextInt(Math.min(16, this.getCellFuel(0)));
                int countCell1 = this.field_145850_b.field_73012_v.nextInt(Math.min(16, this.getCellFuel(1)));
                this.consumeFuel(0, countCell0);
                this.consumeFuel(1, countCell1);
                if (countCell0 > 0 || countCell1 > 0) {
                    this.spawnParticle((IParticleData)ParticleTypes.field_197595_F, pos, countCell0 * 2, 0.06f);
                    this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, pos, 2, 0.0f);
                    this.spawnParticle((IParticleData)ParticleTypes.field_197595_F, oppositePos, countCell1 * 2, 0.06f);
                    this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, oppositePos, 2, 0.0f);
                    LinkedList<BlockPos> flammableBlocks = new LinkedList<BlockPos>();
                    for (int x = -3; x < 3; ++x) {
                        for (int y = -3; y < 2; ++y) {
                            for (int z = -3; z < 3; ++z) {
                                BlockPos firePos = this.func_174877_v().func_177982_a(x, y, z);
                                if (!this.field_145850_b.func_175623_d(firePos)) continue;
                                flammableBlocks.add(firePos);
                            }
                        }
                    }
                    Collections.shuffle(flammableBlocks);
                    flammableBlocks.stream().limit(countCell0 + countCell1).forEach(blockPos -> this.field_145850_b.func_180501_a(blockPos, Blocks.field_150480_ab.func_176223_P(), 11));
                }
            }
            if (this.hasEffect(EnumHammerEffect.DAMAGING)) {
                this.spawnParticle((IParticleData)ParticleTypes.field_197598_I, new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, -0.9, 0.5), 3, 0.1f);
            }
        }
    }

    private int fuelUsage() {
        int usage = 5;
        if (!((Boolean)this.func_195044_w().func_177229_b((IProperty)EnumHammerPlate.east.prop)).booleanValue()) {
            usage += 2;
        }
        if (!((Boolean)this.func_195044_w().func_177229_b((IProperty)EnumHammerPlate.west.prop)).booleanValue()) {
            usage += 2;
        }
        if (this.hasEffect(EnumHammerEffect.OVERCHARGED)) {
            usage += 4;
        }
        if (this.hasEffect(EnumHammerEffect.EFFICIENT)) {
            usage -= 3;
        }
        return Math.max(usage, 1);
    }

    public boolean hasCellInSlot(int index) {
        return index >= 0 && index < this.slots.length && this.slots[index] != null;
    }

    public int getCellFuel(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].func_77973_b() instanceof ItemCellMagmatic) {
            ItemCellMagmatic item = (ItemCellMagmatic)this.slots[index].func_77973_b();
            return item.getCharge(this.slots[index]);
        }
        return -1;
    }

    public ItemStack removeCellFromSlot(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null) {
            ItemStack itemStack = this.slots[index];
            this.slots[index] = null;
            if (index == 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)this.func_195044_w().func_206870_a((IProperty)HammerBaseBlock.propCell1, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)HammerBaseBlock.propCell1Charged, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)this.func_195044_w().func_206870_a((IProperty)HammerBaseBlock.propCell2, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)HammerBaseBlock.propCell2Charged, (Comparable)Boolean.valueOf(false)), 3);
            }
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null) {
            return this.slots[index];
        }
        return ItemStack.field_190927_a;
    }

    public boolean putCellInSlot(ItemStack itemStack, int index) {
        if (itemStack.func_77973_b() instanceof ItemCellMagmatic && index >= 0 && index < this.slots.length && this.slots[index] == null) {
            boolean hasCharge;
            this.slots[index] = itemStack;
            boolean bl = hasCharge = ((ItemCellMagmatic)itemStack.func_77973_b()).getCharge(itemStack) > 0;
            if (index == 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)this.func_195044_w().func_206870_a((IProperty)HammerBaseBlock.propCell1, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)HammerBaseBlock.propCell1Charged, (Comparable)Boolean.valueOf(hasCharge)), 3);
            } else {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)this.func_195044_w().func_206870_a((IProperty)HammerBaseBlock.propCell2, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)HammerBaseBlock.propCell2Charged, (Comparable)Boolean.valueOf(hasCharge)), 3);
            }
            return true;
        }
        return false;
    }

    public void applyReconfigurationEffect() {
        Direction facing = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)HammerBaseBlock.propFacing);
        Direction oppositeFacing = facing.func_176734_d();
        Vec3d pos = new Vec3d((Vec3i)this.func_174877_v());
        pos = pos.func_72441_c(0.5, 0.5, 0.5);
        Vec3d oppositePos = pos.func_178787_e(new Vec3d(facing.func_176734_d().func_176730_m()).func_186678_a(0.55));
        pos = pos.func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a(0.55));
        if (this.hasEffect(EnumHammerEffect.EFFICIENT)) {
            System.out.println("EFFICIENT");
            this.spawnParticle((IParticleData)ParticleTypes.field_197601_L, pos, 5, 0.02f);
            this.spawnParticle((IParticleData)ParticleTypes.field_197601_L, oppositePos, 5, 0.02f);
        }
        if (this.hasEffect(EnumHammerEffect.OVERCHARGED)) {
            System.out.println("OVERCHARGED");
            this.spawnParticle((IParticleData)ParticleTypes.field_197622_o, pos, 15, 0.1f);
            this.spawnParticle((IParticleData)ParticleTypes.field_197622_o, oppositePos, 15, 0.1f);
        }
        if (this.hasEffect(EnumHammerEffect.LEAKY)) {
            System.out.println("LEAKY");
            this.spawnParticle((IParticleData)ParticleTypes.field_197595_F, pos, 3, 0.03f);
            this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, pos, 1, 0.0f);
            this.spawnParticle((IParticleData)ParticleTypes.field_197595_F, oppositePos, 3, 0.03f);
            this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, oppositePos, 1, 0.0f);
        }
        if (this.hasEffect(EnumHammerEffect.DAMAGING)) {
            System.out.println("DAMAGING");
            this.spawnParticle((IParticleData)ParticleTypes.field_197598_I, pos, 1, 0.05f);
            this.spawnParticle((IParticleData)ParticleTypes.field_197598_I, oppositePos, 1, 0.05f);
        }
    }

    private void spawnParticle(IParticleData particle, Vec3d pos, int count, float speed) {
        if (this.field_145850_b instanceof ServerWorld) {
            ((ServerWorld)this.field_145850_b).func_195598_a(particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, count, 0.0, 0.0, 0.0, (double)speed);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(slotsKey)) {
            ListNBT tagList = compound.func_150295_c(slotsKey, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT itemCompound = tagList.func_150305_b(i);
                int slot = itemCompound.func_74771_c(indexKey) & 0xFF;
                if (slot >= this.slots.length) continue;
                this.slots[slot] = ItemStack.func_199557_a((CompoundNBT)itemCompound);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        HammerBaseTile.writeCells(compound, this.slots);
        return compound;
    }

    public static void writeCells(CompoundNBT compound, ItemStack ... cells) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == null) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a(indexKey, (byte)i);
            cells[i].func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.func_218657_a(slotsKey, (INBT)nbttaglist);
    }
}

