/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.transfer;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferConfig;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferEffect;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferState;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitTile;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.forged.ItemVentPlate;
import se.mickelus.tetra.util.TileEntityOptional;

public class TransferUnitBlock
extends TetraWaterloggedBlock
implements IBlockCapabilityInteractive {
    public static final DirectionProperty facingProp = HorizontalBlock.field_185512_D;
    public static final BooleanProperty plateProp = BooleanProperty.func_177716_a((String)"plate");
    public static final IntegerProperty cellProp = IntegerProperty.func_177719_a((String)"cell", (int)0, (int)2);
    public static final EnumProperty<EnumTransferConfig> configProp = EnumProperty.func_177709_a((String)"config", EnumTransferConfig.class);
    public static final EnumProperty<EnumTransferState> transferProp = EnumProperty.func_177709_a((String)"transfer", EnumTransferState.class);
    private static final ResourceLocation plateLootTable = new ResourceLocation("tetra", "forged/plate_break");
    public static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(Capability.pry, 1, Direction.SOUTH, 3.0f, 11.0f, 4.0f, 6.0f, new PropertyMatcher().where(plateProp, Predicates.equalTo((Object)true)), TransferUnitBlock::removePlate), new BlockInteraction(Capability.hammer, 1, Direction.SOUTH, 4.0f, 10.0f, 5.0f, 9.0f, new PropertyMatcher().where(plateProp, Predicates.equalTo((Object)false)), TransferUnitBlock::reconfigure)};
    private static final VoxelShape eastShape = TransferUnitBlock.func_208617_a((double)16.0, (double)0.0, (double)1.0, (double)3.0, (double)12.0, (double)15.0);
    private static final VoxelShape northShape = TransferUnitBlock.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)12.0, (double)13.0);
    private static final VoxelShape westShape = TransferUnitBlock.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)13.0, (double)12.0, (double)15.0);
    private static final VoxelShape southShape = TransferUnitBlock.func_208617_a((double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)12.0, (double)3.0);
    public static final String unlocalizedName = "transfer_unit";
    @ObjectHolder(value="tetra:transfer_unit")
    public static TransferUnitBlock instance;

    public TransferUnitBlock() {
        super(ForgedBlockCommon.properties);
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)plateProp, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)cellProp, (Comparable)Integer.valueOf(0))).func_206870_a(configProp, (Comparable)((Object)EnumTransferConfig.a))).func_206870_a(transferProp, (Comparable)((Object)EnumTransferState.none)));
    }

    @Override
    public void clientInit() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
    }

    public static boolean removePlate(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction hitFace) {
        if (!world.field_72995_K) {
            BlockInteraction.dropLoot(plateLootTable, player, hand, (ServerWorld)world, blockState);
        }
        world.func_184133_a(player, pos, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 1.0f, 0.5f);
        world.func_180501_a(pos, (BlockState)blockState.func_206870_a((IProperty)plateProp, (Comparable)Boolean.valueOf(false)), 3);
        return true;
    }

    public static boolean attachPlate(World world, BlockPos pos, BlockState blockState, PlayerEntity player) {
        world.func_184133_a(player, pos, SoundEvents.field_187772_dn, SoundCategory.PLAYERS, 0.5f, 1.0f);
        world.func_180501_a(pos, (BlockState)blockState.func_206870_a((IProperty)plateProp, (Comparable)Boolean.valueOf(true)), 3);
        return true;
    }

    public static boolean reconfigure(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction hitFace) {
        EnumTransferConfig config = EnumTransferConfig.getNextConfiguration((EnumTransferConfig)((Object)blockState.func_177229_b(configProp)));
        world.func_184133_a(player, pos, SoundEvents.field_187686_e, SoundCategory.PLAYERS, 1.0f, 1.0f);
        world.func_180501_a(pos, (BlockState)blockState.func_206870_a(configProp, (Comparable)((Object)config)), 3);
        TileEntityOptional.from((IBlockReader)world, pos, TransferUnitTile.class).ifPresent(TransferUnitTile::updateTransferState);
        return true;
    }

    public static EnumTransferEffect getEffectPowered(World world, BlockPos pos, BlockState blockState) {
        EnumTransferEffect effect = EnumTransferEffect.fromConfig((EnumTransferConfig)((Object)blockState.func_177229_b(configProp)), 0L);
        if (effect.equals((Object)EnumTransferEffect.redstone)) {
            Direction facing = (Direction)blockState.func_177229_b((IProperty)facingProp);
            if (world.func_175709_b(pos.func_177972_a(facing.func_176746_e()), facing.func_176746_e())) {
                return EnumTransferEffect.send;
            }
            if (world.func_175709_b(pos.func_177972_a(facing.func_176735_f()), facing.func_176735_f())) {
                return EnumTransferEffect.receive;
            }
        }
        return effect;
    }

    public static void setReceiving(World world, BlockPos pos, BlockState blockState, boolean receiving) {
        if (receiving) {
            TransferUnitBlock.setSending(world, pos, blockState, false);
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a(transferProp, (Comparable)((Object)EnumTransferState.receiving)), 3);
        } else {
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a(transferProp, (Comparable)((Object)EnumTransferState.none)), 3);
        }
    }

    public static boolean isReceiving(BlockState blockState) {
        return EnumTransferState.receiving.equals(blockState.func_177229_b(transferProp));
    }

    public static void setSending(World world, BlockPos pos, BlockState blockState, boolean sending) {
        if (sending) {
            TransferUnitBlock.setReceiving(world, pos, blockState, false);
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a(transferProp, (Comparable)((Object)EnumTransferState.sending)), 3);
        } else {
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a(transferProp, (Comparable)((Object)EnumTransferState.none)), 3);
        }
    }

    public static boolean isSending(BlockState blockState) {
        return EnumTransferState.sending.equals(blockState.func_177229_b(transferProp));
    }

    public static boolean hasPlate(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)plateProp);
    }

    public static void updateCellProp(World world, BlockPos pos, boolean hasCell, int cellCharge) {
        BlockState blockState = world.func_180495_p(pos);
        world.func_180501_a(pos, (BlockState)blockState.func_206870_a((IProperty)cellProp, (Comparable)Integer.valueOf(hasCell ? (cellCharge > 0 ? 2 : 1) : 0)), 3);
    }

    public static Direction getFacing(BlockState blockState) {
        return (Direction)blockState.func_177229_b((IProperty)facingProp);
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(BlockState blockState, Direction face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(blockState, (Direction)blockState.func_177229_b((IProperty)facingProp), face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Direction blockFacing = (Direction)state.func_177229_b((IProperty)facingProp);
        TransferUnitTile tile = TileEntityOptional.from((IBlockReader)world, pos, TransferUnitTile.class).orElse(null);
        ItemStack heldStack = player.func_184586_b(hand);
        if (tile == null) {
            return ActionResultType.FAIL;
        }
        if (hit.func_216354_b().equals((Object)Direction.UP)) {
            if (tile.hasCell()) {
                ItemStack cell = tile.removeCell();
                if (player.field_71071_by.func_70441_a(cell)) {
                    player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                } else {
                    TransferUnitBlock.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)cell);
                }
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.6f);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, state, ItemStack.field_190927_a);
                }
                return ActionResultType.SUCCESS;
            }
            if (heldStack.func_77973_b() instanceof ItemCellMagmatic) {
                tile.putCell(heldStack);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.5f);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, state, ItemStack.field_190927_a);
                }
                return ActionResultType.SUCCESS;
            }
        } else if (blockFacing.equals((Object)hit.func_216354_b().func_176734_d()) && heldStack.func_77973_b() instanceof ItemVentPlate && !((Boolean)state.func_177229_b((IProperty)plateProp)).booleanValue()) {
            TransferUnitBlock.attachPlate(world, pos, state, player);
            heldStack.func_190918_g(1);
            if (!player.field_70170_p.field_72995_K) {
                BlockUseCriterion.trigger((ServerPlayerEntity)player, state, ItemStack.field_190927_a);
            }
            return ActionResultType.SUCCESS;
        }
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.func_177230_c())) {
            TileEntityOptional.from((IBlockReader)world, pos, TransferUnitTile.class).ifPresent(tile -> {
                if (tile.hasCell()) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.getCell().func_77946_l());
                }
            });
            TileEntityOptional.from((IBlockReader)world, pos, TransferUnitTile.class).ifPresent(TileEntity::func_145843_s);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        if (!pos.func_177972_a((Direction)world.func_180495_p(pos).func_177229_b((IProperty)facingProp)).equals((Object)fromPos)) {
            TileEntityOptional.from((IBlockReader)world, pos, TransferUnitTile.class).ifPresent(TransferUnitTile::updateTransferState);
        }
    }

    public boolean func_229869_c_(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((IProperty)facingProp);
        switch (facing) {
            case NORTH: {
                return northShape;
            }
            case EAST: {
                return eastShape;
            }
            case SOUTH: {
                return southShape;
            }
            case WEST: {
                return westShape;
            }
        }
        return null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{facingProp, configProp, plateProp, cellProp, transferProp});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TransferUnitTile();
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)facingProp, (Comparable)context.func_195992_f());
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)facingProp, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)facingProp)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)facingProp)));
    }
}

