/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiButton;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiText;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchemaListItem;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiSchemaList
extends GuiElement {
    private static int pageLength = 8;
    private int page = 0;
    private UpgradeSchema[] schemas;
    private Consumer<UpgradeSchema> schemaSelectionConsumer;
    private GuiElement listGroup = new GuiElement(3, 3, this.width - 6, this.height - 6);
    private GuiButton buttonBack;
    private GuiButton buttonForward;
    private GuiText emptyStateText;

    public GuiSchemaList(int x, int y, Consumer<UpgradeSchema> schemaSelectionConsumer) {
        super(x, y, 224, 67);
        this.addChild(this.listGroup);
        this.buttonBack = new GuiButton(-25, this.height + 4, 45, 12, "< Previous", () -> this.setPage(this.getPage() - 1));
        this.addChild((GuiElement)this.buttonBack);
        this.buttonForward = new GuiButton(this.width - 20, this.height + 4, 30, 12, "Next >", () -> this.setPage(this.getPage() + 1));
        this.addChild((GuiElement)this.buttonForward);
        this.emptyStateText = new GuiText(10, 23, 204, TextFormatting.GRAY + I18n.func_135052_a((String)"tetra.workbench.schema_list.empty", (Object[])new Object[0]));
        this.addChild((GuiElement)this.emptyStateText);
        this.schemaSelectionConsumer = schemaSelectionConsumer;
    }

    public void setSchemas(UpgradeSchema[] schemas) {
        this.schemas = schemas;
        this.emptyStateText.setVisible(schemas.length == 0);
        this.setPage(0);
    }

    private void updateSchemas() {
        int count = pageLength;
        int offset = this.page * pageLength;
        if (count + offset > this.schemas.length) {
            count = this.schemas.length - offset;
        }
        this.listGroup.clearChildren();
        for (int i = 0; i < count; ++i) {
            UpgradeSchema schema = this.schemas[i + offset];
            this.listGroup.addChild((GuiElement)new GuiSchemaListItem(i / (pageLength / 2) * 109, i % (pageLength / 2) * 14, schema, () -> this.schemaSelectionConsumer.accept(schema)));
        }
    }

    private int getPage() {
        return this.page;
    }

    private void setPage(int page) {
        this.page = page;
        this.buttonBack.setVisible(page > 0);
        this.buttonForward.setVisible(page < this.getNumPages() - 1);
        this.updateSchemas();
    }

    private int getNumPages() {
        return (int)Math.ceil(1.0f * (float)this.schemas.length / (float)pageLength);
    }
}

