/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.tetra.gui.GuiSliderSegmented;
import se.mickelus.tetra.module.data.TweakData;

public class GuiTweakSlider
extends GuiElement {
    private GuiString labelString;
    private GuiSliderSegmented slider;
    private List<String> tooltip;
    private int steps;

    public GuiTweakSlider(int x, int y, int width, TweakData tweak, Consumer<Integer> onChange) {
        super(x, y, width, 16);
        this.labelString = new GuiStringSmall(0, 0, I18n.func_135052_a((String)("tetra.tweak." + tweak.key + ".label"), (Object[])new Object[0]));
        this.labelString.setAttachment(GuiAttachment.topCenter);
        this.addChild((GuiElement)this.labelString);
        this.addChild(new GuiStringSmall(-2, 1, I18n.func_135052_a((String)("tetra.tweak." + tweak.key + ".left"), (Object[])new Object[0])).setAttachment(GuiAttachment.bottomLeft));
        this.addChild(new GuiStringSmall(-1, 1, I18n.func_135052_a((String)("tetra.tweak." + tweak.key + ".right"), (Object[])new Object[0])).setAttachment(GuiAttachment.bottomRight));
        this.slider = new GuiSliderSegmented(-2, 3, width, tweak.steps * 2 + 1, step -> onChange.accept(step - tweak.steps));
        this.slider.setAttachment(GuiAttachment.topCenter);
        this.addChild((GuiElement)this.slider);
        this.steps = tweak.steps;
        this.tooltip = Collections.singletonList(I18n.func_135052_a((String)("tetra.tweak." + tweak.key + ".tooltip"), (Object[])new Object[0]));
    }

    public void setValue(int value) {
        this.slider.setValue(value + this.steps);
    }

    public List<String> getTooltipLines() {
        if (this.labelString.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

