/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.statbar.GuiStatBar;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.statbar.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.statbar.getter.TooltipGetterBlockingDuration;
import se.mickelus.tetra.module.ItemEffect;

public class GuiStatBarBlockingDuration
extends GuiStatBar {
    private static final IStatGetter durationGetter = new StatGetterEffectLevel(ItemEffect.blocking, 1.0);
    private IStatGetter reflectGetter = new StatGetterEffectLevel(ItemEffect.blockingReflect, 1.0);
    private GuiTexture reflectIndicator = new GuiTexture(this.labelString.getWidth() + 2, -1, 7, 7, 220, 0, GuiTextures.workbench);

    public GuiStatBarBlockingDuration(int x, int y, int width) {
        super(x, y, width, I18n.func_135052_a((String)"tetra.stats.blocking", (Object[])new Object[0]), 0.0, 16.0, false, durationGetter, LabelGetterBasic.integerLabel, new TooltipGetterBlockingDuration(durationGetter));
        this.addChild((GuiElement)this.reflectIndicator);
    }

    @Override
    public void update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        super.update(player, currentStack, previewStack, slot, improvement);
        if (durationGetter.getValue(player, currentStack) >= 16.0 || durationGetter.getValue(player, previewStack) >= 16.0) {
            this.valueString.setString("");
        }
        this.updateIndicators(player, currentStack, previewStack, slot, improvement);
    }

    private void updateIndicators(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        int currentStriking;
        int previewStriking = currentStriking = (int)this.reflectGetter.getValue(player, currentStack);
        if (!previewStack.func_190926_b()) {
            previewStriking = (int)this.reflectGetter.getValue(player, previewStack);
        } else if (slot != null) {
            if (improvement != null) {
                previewStriking = (int)this.reflectGetter.getValue(player, currentStack, slot, improvement);
                currentStriking -= previewStriking;
            } else {
                previewStriking = (int)this.reflectGetter.getValue(player, currentStack, slot);
                currentStriking -= previewStriking;
            }
        }
        this.reflectIndicator.setVisible(currentStriking > 0 || previewStriking > 0);
        this.reflectIndicator.setColor(this.getDiffColor(currentStriking, previewStriking));
    }

    @Override
    protected void realign() {
        super.realign();
        this.reflectIndicator.setAttachment(this.alignment.toAttachment().flipHorizontal());
        int offset = this.valueString.getWidth() + 2;
        this.reflectIndicator.setX(GuiAlignment.right.equals((Object)this.alignment) ? offset : -offset);
    }

    protected int getDiffColor(int currentValue, int previewValue) {
        if (previewValue > currentValue) {
            return 0x55FF55;
        }
        if (previewValue < currentValue) {
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }
}

