/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar.getter;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.ITooltipGetter;
import se.mickelus.tetra.gui.statbar.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.statbar.getter.StatGetterEffectLevel;
import se.mickelus.tetra.module.ItemEffect;

public class TooltipGetterBlockingDuration
implements ITooltipGetter {
    private IStatGetter durationGetter;
    private static final String reflectKey = "tetra.stats.blocking_reflect.tooltip";
    private IStatGetter reflectLevelGetter;
    private IStatGetter reflectEfficiencyGetter;

    public TooltipGetterBlockingDuration(IStatGetter durationGetter) {
        this.durationGetter = durationGetter;
        this.reflectLevelGetter = new StatGetterEffectLevel(ItemEffect.blockingReflect, 1.0);
        this.reflectEfficiencyGetter = new StatGetterEffectEfficiency(ItemEffect.blockingReflect, 1.0);
    }

    @Override
    public String getTooltipBase(PlayerEntity player, ItemStack itemStack) {
        String modifier = "";
        double reflectLevel = this.reflectLevelGetter.getValue(player, itemStack);
        if (reflectLevel > 0.0) {
            modifier = "\n\n" + I18n.func_135052_a((String)reflectKey, (Object[])new Object[]{String.format("%.0f%%", reflectLevel), String.format("%.0f%%", this.reflectEfficiencyGetter.getValue(player, itemStack) * 100.0)});
        }
        if (this.durationGetter.getValue(player, itemStack) < 16.0) {
            return I18n.func_135052_a((String)"tetra.stats.blocking_duration.tooltip", (Object[])new Object[]{this.durationGetter.getValue(player, itemStack)}) + modifier;
        }
        return I18n.func_135052_a((String)"tetra.stats.blocking.tooltip", (Object[])new Object[0]) + modifier;
    }

    @Override
    public boolean hasExtendedTooltip(PlayerEntity player, ItemStack itemStack) {
        return true;
    }

    @Override
    public String getTooltipExtension(PlayerEntity player, ItemStack itemStack) {
        return I18n.func_135052_a((String)"tetra.stats.blocking.tooltip_extended", (Object[])new Object[0]);
    }
}

