/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.network.AbstractPacket;

public class SecondaryAbilityPacket
extends AbstractPacket {
    private int targetId = -1;
    private Hand hand;

    public SecondaryAbilityPacket() {
    }

    public SecondaryAbilityPacket(LivingEntity target, Hand hand) {
        this.targetId = Optional.ofNullable(target).map(Entity::func_145782_y).orElse(-1);
        this.hand = hand;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.targetId);
        buffer.writeInt(this.hand.ordinal());
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.targetId = buffer.readInt();
        this.hand = Hand.values()[buffer.readInt()];
    }

    @Override
    public void handle(PlayerEntity player) {
        LivingEntity target = Optional.of(this.targetId).filter(id -> id != -1).map(id -> player.field_70170_p.func_73045_a(id.intValue())).filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).orElse(null);
        ItemModularHandheld.handleSecondaryAbility(player, this.hand, target);
    }
}

