/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import se.mickelus.tetra.items.modular.impl.toolbelt.EquipToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiToolbelt;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;
import se.mickelus.tetra.network.PacketHandler;

public class OverlayToolbelt {
    public static OverlayToolbelt instance;
    private final Minecraft mc;
    public static final String bindingGroup = "tetra.toolbelt.binding.group";
    public KeyBinding accessBinding;
    public KeyBinding restockBinding;
    private long openTime = -1L;
    private boolean isActive = false;
    private OverlayGuiToolbelt gui;

    public OverlayToolbelt(Minecraft mc) {
        this.mc = mc;
        this.gui = new OverlayGuiToolbelt(mc);
        this.accessBinding = new KeyBinding("tetra.toolbelt.binding.access", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 86, bindingGroup);
        this.restockBinding = new KeyBinding("tetra.toolbelt.binding.restock", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, InputMappings.Type.KEYSYM, 86, bindingGroup);
        ClientRegistry.registerKeyBinding((KeyBinding)this.accessBinding);
        ClientRegistry.registerKeyBinding((KeyBinding)this.restockBinding);
        instance = this;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (this.restockBinding.func_151470_d()) {
            this.equipToolbeltItem(ToolbeltSlotType.quickslot, -1, Hand.OFF_HAND);
        } else if (this.accessBinding.func_151470_d() && this.mc.func_195544_aj() && !this.isActive) {
            this.showView();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (!this.accessBinding.func_151470_d() && this.isActive) {
            this.hideView();
        }
        this.gui.draw();
    }

    private void showView() {
        boolean canOpen = this.updateGuiData();
        if (canOpen) {
            this.mc.field_71417_B.func_198032_j();
            this.isActive = true;
            this.openTime = System.currentTimeMillis();
        }
    }

    private void hideView() {
        this.gui.setVisible(false);
        this.mc.field_71417_B.func_198034_i();
        this.isActive = false;
        int focusIndex = this.findIndex();
        if (focusIndex != -1) {
            this.equipToolbeltItem(this.findSlotType(), focusIndex, Hand.OFF_HAND);
        } else if (System.currentTimeMillis() - this.openTime < 500L) {
            this.quickEquip();
        }
    }

    private void equipToolbeltItem(ToolbeltSlotType slotType, int toolbeltItemIndex, Hand hand) {
        EquipToolbeltItemPacket packet = new EquipToolbeltItemPacket(slotType, toolbeltItemIndex, hand);
        PacketHandler.sendToServer(packet);
        if (toolbeltItemIndex > -1) {
            ToolbeltHelper.equipItemFromToolbelt((PlayerEntity)this.mc.field_71439_g, slotType, toolbeltItemIndex, hand);
        } else {
            boolean storeItemSuccess = ToolbeltHelper.storeItemInToolbelt((PlayerEntity)this.mc.field_71439_g);
            if (!storeItemSuccess) {
                this.mc.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("tetra.toolbelt.full", new Object[0]), true);
            }
        }
    }

    private void quickEquip() {
        BlockState blockState;
        int index;
        if (this.mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && (index = ToolbeltHelper.getQuickAccessSlotIndex((PlayerEntity)this.mc.field_71439_g, this.mc.field_71476_x, blockState = this.mc.field_71441_e.func_180495_p(new BlockPos(this.mc.field_71476_x.func_216347_e())))) > -1) {
            this.equipToolbeltItem(ToolbeltSlotType.quickslot, index, Hand.MAIN_HAND);
        }
    }

    private boolean updateGuiData() {
        ItemStack itemStack = ToolbeltHelper.findToolbelt((PlayerEntity)this.mc.field_71439_g);
        if (!itemStack.func_190926_b()) {
            this.gui.setInventories(itemStack);
            this.gui.setVisible(true);
            return true;
        }
        return false;
    }

    private int findIndex() {
        return this.gui.getFocusIndex();
    }

    private ToolbeltSlotType findSlotType() {
        return this.gui.getFocusType();
    }
}

