/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.ICapabilityProvider;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.ModuleVariantData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.schema.RepairDefinition;

public abstract class ItemModule
implements ICapabilityProvider {
    protected ModuleVariantData[] variantData = new ModuleVariantData[0];
    protected TweakData[] tweaks = new TweakData[0];
    protected final String slotTagKey;
    protected final String moduleKey;
    protected final String variantTagKey;
    protected Priority renderLayer = Priority.BASE;

    public ItemModule(String slotKey, String moduleKey) {
        this.slotTagKey = slotKey;
        this.moduleKey = moduleKey;
        this.variantTagKey = moduleKey + "_material";
    }

    public String getKey() {
        return this.moduleKey;
    }

    public String getUnlocalizedName() {
        return this.moduleKey;
    }

    public String getSlot() {
        return this.slotTagKey;
    }

    public void addModule(ItemStack targetStack, String variantKey, PlayerEntity player) {
        CompoundNBT tag = NBTHelper.getTag(targetStack);
        tag.func_74778_a(this.slotTagKey, this.moduleKey);
        tag.func_74778_a(this.variantTagKey, variantKey);
    }

    public ItemStack[] removeModule(ItemStack targetStack) {
        CompoundNBT tag = NBTHelper.getTag(targetStack);
        tag.func_82580_o(this.slotTagKey);
        tag.func_82580_o(this.variantTagKey);
        return new ItemStack[0];
    }

    public void postRemove(ItemStack targetStack, PlayerEntity player) {
    }

    public ModuleVariantData[] getVariantData() {
        return this.variantData;
    }

    public ModuleVariantData getVariantData(ItemStack itemStack) {
        CompoundNBT tag = NBTHelper.getTag(itemStack);
        String variantKey = tag.func_74779_i(this.variantTagKey);
        return this.getVariantData(variantKey);
    }

    public ModuleVariantData getVariantData(String variantKey) {
        return Arrays.stream(this.variantData).filter(moduleData -> moduleData.key.equals(variantKey)).findAny().orElseGet(this::getDefaultData);
    }

    public ModuleVariantData getDefaultData() {
        return this.variantData.length > 0 ? this.variantData[0] : new ModuleVariantData();
    }

    public String getName(ItemStack itemStack) {
        return I18n.func_135052_a((String)("tetra.variant." + this.getVariantData((ItemStack)itemStack).key), (Object[])new Object[0]);
    }

    public String getDescription(ItemStack itemStack) {
        String descriptionKey = "tetra.variant." + this.getVariantData((ItemStack)itemStack).key + ".description";
        if (I18n.func_188566_a((String)descriptionKey)) {
            return I18n.func_135052_a((String)descriptionKey, (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)("tetra.module." + this.getUnlocalizedName() + ".description"), (Object[])new Object[0]);
    }

    public String getItemName(ItemStack itemStack) {
        String variantItemNameKey = "tetra.variant." + this.getVariantData((ItemStack)itemStack).key + ".item_name";
        if (I18n.func_188566_a((String)variantItemNameKey)) {
            return I18n.func_135052_a((String)variantItemNameKey, (Object[])new Object[0]);
        }
        String moduleItemNameKey = "tetra.module." + this.getUnlocalizedName() + ".item_name";
        if (I18n.func_188566_a((String)moduleItemNameKey)) {
            return I18n.func_135052_a((String)moduleItemNameKey, (Object[])new Object[0]);
        }
        return null;
    }

    public Priority getItemNamePriority(ItemStack itemStack) {
        return Priority.BASE;
    }

    public String getItemPrefix(ItemStack itemStack) {
        String variantPrefixKey = "tetra.variant." + this.getVariantData((ItemStack)itemStack).key + ".prefix";
        if (I18n.func_188566_a((String)variantPrefixKey)) {
            return I18n.func_135052_a((String)variantPrefixKey, (Object[])new Object[0]);
        }
        String modulePrefixKey = "tetra.module." + this.getUnlocalizedName() + ".prefix";
        if (I18n.func_188566_a((String)modulePrefixKey)) {
            return I18n.func_135052_a((String)modulePrefixKey, (Object[])new Object[0]);
        }
        return null;
    }

    public Priority getItemPrefixPriority(ItemStack itemStack) {
        return Priority.BASE;
    }

    public int getIntegrityGain(ItemStack itemStack) {
        int integrity = this.getVariantData((ItemStack)itemStack).integrity;
        if (integrity > 0) {
            return integrity;
        }
        return 0;
    }

    public int getIntegrityCost(ItemStack itemStack) {
        int integrity = this.getVariantData((ItemStack)itemStack).integrity;
        if (integrity < 0) {
            return integrity;
        }
        return 0;
    }

    public int getMagicCapacity(ItemStack itemStack) {
        return this.getMagicCapacityGain(itemStack) - this.getMagicCapacityCost(itemStack);
    }

    public int getMagicCapacityGain(ItemStack itemStack) {
        int magicCapacity = this.getVariantData((ItemStack)itemStack).magicCapacity;
        if (magicCapacity > 0) {
            return Math.round((float)magicCapacity * ((Double)ConfigHandler.magicCapacityMultiplier.get()).floatValue());
        }
        return 0;
    }

    public int getMagicCapacityCost(ItemStack itemStack) {
        int magicCapacity = this.getVariantData((ItemStack)itemStack).magicCapacity;
        if (magicCapacity < 0) {
            return -magicCapacity;
        }
        return 0;
    }

    public int getDurability(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToInt(tweak -> tweak.getDurability(this.getTweakStep(itemStack, (TweakData)tweak))).sum() + this.getVariantData((ItemStack)itemStack).durability;
    }

    public float getDurabilityMultiplier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> Float.valueOf(tweak.getDurabilityMultiplier(this.getTweakStep(itemStack, (TweakData)tweak)))).reduce(Float.valueOf(this.getVariantData((ItemStack)itemStack).durabilityMultiplier), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public Collection<RepairDefinition> getRepairDefinitions(ItemStack itemStack) {
        return RepairRegistry.instance.getDefinitions(this.getVariantData((ItemStack)itemStack).key);
    }

    public RepairDefinition getRepairDefinition(ItemStack itemStack, ItemStack materialStack) {
        return RepairRegistry.instance.getDefinitions(this.getVariantData((ItemStack)itemStack).key).stream().filter(definition -> definition.material.predicate.func_192493_a(materialStack)).findFirst().orElse(null);
    }

    public Collection<Capability> getRepairRequiredCapabilities(ItemStack itemStack, ItemStack materialStack) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredCapabilities.getValues()).orElse(Collections.emptySet());
    }

    public int getRepairRequiredCapabilityLevel(ItemStack itemStack, ItemStack materialStack, Capability capability) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredCapabilities.getLevel(capability)).orElse(0);
    }

    public boolean isTweakable(ItemStack itemStack) {
        String variant = NBTHelper.getTag(itemStack).func_74779_i(this.variantTagKey);
        return Arrays.stream(this.tweaks).anyMatch(data -> variant.equals(data.variant));
    }

    public TweakData[] getTweaks(ItemStack itemStack) {
        CompoundNBT tag = NBTHelper.getTag(itemStack);
        String variant = tag.func_74779_i(this.variantTagKey);
        return (TweakData[])Arrays.stream(this.tweaks).filter(tweak -> variant.equals(tweak.variant)).toArray(TweakData[]::new);
    }

    public boolean hasTweak(ItemStack itemStack, String tweakKey) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.key).anyMatch(tweakKey::equals);
    }

    public int getTweakStep(ItemStack itemStack, TweakData tweak) {
        return Math.max(Math.min(NBTHelper.getTag(itemStack).func_74762_e(this.slotTagKey + ":" + tweak.key), tweak.steps), -tweak.steps);
    }

    public void setTweakStep(ItemStack itemStack, String tweakKey, int step) {
        NBTHelper.getTag(itemStack).func_74768_a(this.slotTagKey + ":" + tweakKey, step);
    }

    public double getDamageModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getDamage(this.getTweakStep(itemStack, (TweakData)tweak))).sum() + (double)this.getVariantData((ItemStack)itemStack).damage;
    }

    public double getDamageMultiplierModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> Float.valueOf(tweak.getDamageMultiplier(this.getTweakStep(itemStack, (TweakData)tweak)))).reduce(Float.valueOf(this.getVariantData((ItemStack)itemStack).damageMultiplier), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public double getSpeedModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getAttackSpeed(this.getTweakStep(itemStack, (TweakData)tweak))).sum() + (double)this.getVariantData((ItemStack)itemStack).attackSpeed;
    }

    public double getSpeedMultiplierModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> Float.valueOf(tweak.getAttackSpeedMultiplier(this.getTweakStep(itemStack, (TweakData)tweak)))).reduce(Float.valueOf(this.getVariantData((ItemStack)itemStack).attackSpeedMultiplier), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    public double getRangeModifier(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getRange(this.getTweakStep(itemStack, (TweakData)tweak))).sum() + (double)this.getVariantData((ItemStack)itemStack).range;
    }

    public ModuleModel[] getModels(ItemStack itemStack) {
        return this.getVariantData((ItemStack)itemStack).models;
    }

    public Priority getRenderLayer() {
        return this.renderLayer;
    }

    public void hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
    }

    public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToInt(tweak -> tweak.getEffectLevel(effect, this.getTweakStep(itemStack, (TweakData)tweak))).sum() + this.getVariantData((ItemStack)itemStack).effects.getLevel(effect);
    }

    public float getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        return (float)Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getEffectEfficiency(effect, this.getTweakStep(itemStack, (TweakData)tweak))).sum() + this.getVariantData((ItemStack)itemStack).effects.getEfficiency(effect);
    }

    public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        return this.getVariantData((ItemStack)itemStack).effects.getValues();
    }

    @Override
    public int getCapabilityLevel(ItemStack itemStack, Capability capability) {
        return Arrays.stream(this.getTweaks(itemStack)).mapToInt(tweak -> tweak.getCapabilityLevel(capability, this.getTweakStep(itemStack, (TweakData)tweak))).sum() + this.getVariantData((ItemStack)itemStack).capabilities.getLevel(capability);
    }

    @Override
    public float getCapabilityEfficiency(ItemStack itemStack, Capability capability) {
        return (float)Arrays.stream(this.getTweaks(itemStack)).mapToDouble(tweak -> tweak.getCapabilityEfficiency(capability, this.getTweakStep(itemStack, (TweakData)tweak))).sum() + this.getVariantData((ItemStack)itemStack).capabilities.getEfficiency(capability);
    }

    @Override
    public Set<Capability> getCapabilities(ItemStack itemStack) {
        return this.getVariantData((ItemStack)itemStack).capabilities.getValues();
    }
}

