/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.ModuleData;

public class ModuleRegistry {
    private static final Logger logger = LogManager.getLogger();
    public static ModuleRegistry instance;
    private Map<ResourceLocation, BiFunction<ResourceLocation, ModuleData, ItemModule>> moduleConstructors;
    private Map<ResourceLocation, ItemModule> moduleMap;

    public ModuleRegistry() {
        instance = this;
        this.moduleConstructors = new HashMap<ResourceLocation, BiFunction<ResourceLocation, ModuleData, ItemModule>>();
        this.moduleMap = Collections.emptyMap();
        DataManager.moduleData.onReload(() -> this.setupModules(DataManager.moduleData.getData()));
    }

    private void setupModules(Map<ResourceLocation, ModuleData> data) {
        this.moduleMap = data.entrySet().stream().filter(entry -> this.validateModuleData((ResourceLocation)entry.getKey(), (ModuleData)entry.getValue())).flatMap(entry -> this.expandEntry((Map.Entry<ResourceLocation, ModuleData>)entry).stream()).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.setupModule((ResourceLocation)entry.getKey(), (ModuleData)entry.getValue())));
    }

    private boolean validateModuleData(ResourceLocation identifier, ModuleData data) {
        if (data == null) {
            logger.warn("Failed to create module from module data '{}': Data is null (probably due to it failing to parse)", (Object)identifier);
            return false;
        }
        if (!this.moduleConstructors.containsKey(data.type)) {
            logger.warn("Failed to create module from module data '{}': Unknown type '{}'", (Object)identifier, (Object)data.type);
            return false;
        }
        if (data.slots == null || data.slots.length < 1) {
            logger.warn("Failed to create module from module data '{}': Slots field is empty", (Object)identifier);
            return false;
        }
        return true;
    }

    private Collection<Pair<ResourceLocation, ModuleData>> expandEntry(Map.Entry<ResourceLocation, ModuleData> entry) {
        ModuleData moduleData = entry.getValue();
        if (moduleData.slotSuffixes.length > 0) {
            ArrayList<Pair<ResourceLocation, ModuleData>> result = new ArrayList<Pair<ResourceLocation, ModuleData>>(moduleData.slots.length);
            for (int i = 0; i < moduleData.slots.length; ++i) {
                ModuleData dataCopy = moduleData.shallowCopy();
                dataCopy.slots = new String[]{moduleData.slots[i]};
                dataCopy.slotSuffixes = new String[]{moduleData.slotSuffixes[i]};
                ResourceLocation suffixedIdentifier = new ResourceLocation(entry.getKey().func_110624_b(), entry.getKey().func_110623_a() + moduleData.slotSuffixes[i]);
                result.add((Pair<ResourceLocation, ModuleData>)new ImmutablePair((Object)suffixedIdentifier, (Object)dataCopy));
            }
            return result;
        }
        return Collections.singletonList(new ImmutablePair((Object)entry.getKey(), (Object)entry.getValue()));
    }

    private ItemModule setupModule(ResourceLocation identifier, ModuleData data) {
        return this.moduleConstructors.get(data.type).apply(identifier, data);
    }

    public void registerModuleType(ResourceLocation identifier, BiFunction<ResourceLocation, ModuleData, ItemModule> constructor) {
        this.moduleConstructors.put(identifier, constructor);
    }

    public ItemModule getModule(ResourceLocation identifier) {
        return this.moduleMap.get(identifier);
    }

    public Collection<ItemModule> getAllModules() {
        return this.moduleMap.values();
    }
}

