/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.util.CastOptional;

public class BookEnchantSchema
implements UpgradeSchema {
    private static final String localizationPrefix = "tetra/schema/";
    private static final String key = "book_enchant";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String slotSuffix = ".slot1";
    private GlyphData glyph = new GlyphData(GuiTextures.workbench, 80, 32);

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"tetra/schema/book_enchant.name", (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)"tetra/schema/book_enchant.description", (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return I18n.func_135052_a((String)"tetra/schema/book_enchant.slot1", (Object[])new Object[0]);
    }

    @Override
    public ItemStack[] getSlotPlaceholders(ItemStack itemStack, int index) {
        return new ItemStack[]{Items.field_151134_bR.func_190903_i()};
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 1;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        ItemModuleMajor module = CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(itemStack, itemSlot)).flatMap(mod -> CastOptional.cast(mod, ItemModuleMajor.class)).orElse(null);
        return module != null && !materialStack.func_190926_b() && materialStack.func_77973_b() instanceof EnchantedBookItem && EnchantmentHelper.func_82781_a((ItemStack)materialStack).entrySet().stream().anyMatch(entry -> Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings((Enchantment)entry.getKey())).anyMatch(mapping -> module.acceptsImprovementLevel(mapping.improvement, (int)((float)((Integer)entry.getValue()).intValue() / mapping.multiplier))));
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return this.acceptsMaterial(itemStack, itemSlot, 0, materials[0]);
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ModularItem;
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return CastOptional.cast(targetStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(targetStack, slot)).map(module -> module.getMagicCapacityGain(targetStack) > 0).orElse(false);
    }

    @Override
    public boolean canApplyUpgrade(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot, int[] availableCapabilities) {
        return this.isMaterialsValid(itemStack, slot, materials) && (player.func_184812_l_() || player.field_71068_ca >= this.getExperienceCost(itemStack, materials, slot));
    }

    @Override
    public boolean isIntegrityViolation(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, PlayerEntity player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        ItemModuleMajor module = CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).filter(mod -> mod instanceof ItemModuleMajor).map(mod -> (ItemModuleMajor)mod).orElse(null);
        if (module != null) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)materials[0]);
            for (Map.Entry entry : enchantments.entrySet()) {
                for (EnchantmentMapping mapping : ItemUpgradeRegistry.instance.getEnchantmentMappings((Enchantment)entry.getKey())) {
                    if (!module.acceptsImprovementLevel(mapping.improvement, (Integer)entry.getValue())) continue;
                    module.addImprovement(upgradedStack, mapping.improvement, (Integer)entry.getValue());
                    if (!consumeMaterials || !(player instanceof ServerPlayerEntity)) continue;
                    ImprovementCraftCriterion.trigger((ServerPlayerEntity)player, itemStack, upgradedStack, this.getKey(), slot, mapping.improvement, (int)((float)((Integer)entry.getValue()).intValue() / mapping.multiplier), null, -1);
                }
            }
            if (consumeMaterials) {
                materials[0].func_190918_g(1);
            }
        }
        return upgradedStack;
    }

    @Override
    public boolean checkCapabilities(ItemStack targetStack, ItemStack[] materials, int[] availableCapabilities) {
        return true;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        return Collections.emptyList();
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        return 0;
    }

    @Override
    public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        return CastOptional.cast(targetStack.func_77973_b(), ModularItem.class).map(item -> item.getModuleFromSlot(targetStack, slot)).filter(module -> module instanceof ItemModuleMajor).map(module -> (ItemModuleMajor)module).map(module -> {
            int cost = 0;
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)materials[0]);
            for (Map.Entry entry : enchantments.entrySet()) {
                for (EnchantmentMapping mapping : ItemUpgradeRegistry.instance.getEnchantmentMappings((Enchantment)entry.getKey())) {
                    if (!module.acceptsImprovementLevel(mapping.improvement, (int)((float)((Integer)entry.getValue()).intValue() / mapping.multiplier))) continue;
                    cost = (int)((float)cost + (float)((Integer)entry.getValue()).intValue() / mapping.multiplier);
                }
            }
            int capacityPenalty = Math.max(0, -module.getMagicCapacity(targetStack));
            return cost + capacityPenalty;
        }).orElse(0);
    }

    @Override
    public SchemaType getType() {
        return SchemaType.improvement;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }

    @Override
    public OutcomePreview[] getPreviews(ItemStack targetStack, String slot) {
        return new OutcomePreview[0];
    }
}

