/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.structure;

import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import hellfirepvp.observerlib.api.util.ContentSerializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.ObjectUtils;

public interface Structure
extends ContentSerializable {
    @Nonnull
    public Map<BlockPos, ? extends MatchableState> getContents();

    @Nonnull
    public Map<BlockPos, ? extends MatchableTile<? extends TileEntity>> getTileEntities();

    public Vec3i getMaximumOffset();

    public Vec3i getMinimumOffset();

    default public boolean hasBlockAt(BlockPos offset) {
        return this.getContents().containsKey(offset);
    }

    @Nonnull
    default public MatchableState getBlockStateAt(BlockPos offset) {
        if (!this.hasBlockAt(offset)) {
            return MatchableState.IS_AIR;
        }
        return (MatchableState)ObjectUtils.firstNonNull((Object[])new MatchableState[]{this.getContents().get(offset), MatchableState.IS_AIR});
    }

    default public boolean hasTileAt(BlockPos offset) {
        return this.getTileEntities().containsKey(offset);
    }

    @Nullable
    default public MatchableTile<? extends TileEntity> getTileEntityAt(BlockPos offset) {
        if (!this.hasTileAt(offset)) {
            return null;
        }
        return this.getTileEntities().get(offset);
    }

    default public List<Tuple<BlockPos, ? extends MatchableState>> getStructureSlice(int yOffset) {
        return this.getContents().entrySet().stream().filter(e -> ((BlockPos)e.getKey()).func_177956_o() == yOffset).map(e -> new Tuple(e.getKey(), e.getValue())).collect(Collectors.toList());
    }
}

