/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.change;

import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ObservableArea;
import hellfirepvp.observerlib.api.ObservableAreaBoundingBox;
import hellfirepvp.observerlib.api.block.BlockChangeSet;
import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.common.util.NBTHelper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class ChangeObserverStructure
extends ChangeObserver {
    private final MatchableStructure structure;
    private final ObservableArea observedArea;
    private Set<BlockPos> mismatches = new HashSet<BlockPos>();

    public ChangeObserverStructure(MatchableStructure structure) {
        super(structure.getRegistryName());
        this.structure = structure;
        this.observedArea = new ObservableAreaBoundingBox(structure.getMinimumOffset(), structure.getMaximumOffset());
    }

    @Override
    public void initialize(IWorld world, BlockPos center) {
        for (BlockPos offset : this.structure.getContents().keySet()) {
            if (this.structure.matchesSingleBlock((IBlockReader)world, center, offset)) continue;
            this.mismatches.add(offset);
        }
    }

    @Override
    @Nonnull
    public ObservableArea getObservableArea() {
        return this.observedArea;
    }

    @Override
    public boolean notifyChange(IWorld world, BlockPos center, BlockChangeSet changeSet) {
        for (BlockChangeSet.StateChange change : changeSet.getChanges()) {
            if (this.structure.hasBlockAt(change.getRelativePosition()) && !this.structure.matchesSingleBlock((IBlockReader)world, center, change.getRelativePosition(), change.getNewState(), world.func_175625_s(center.func_177971_a((Vec3i)change.getRelativePosition())))) {
                this.mismatches.add(change.getRelativePosition());
                continue;
            }
            this.mismatches.remove(change.getRelativePosition());
        }
        this.mismatches.removeIf(mismatchPos -> !this.structure.hasBlockAt((BlockPos)mismatchPos));
        return this.mismatches.size() <= 0;
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.mismatches.clear();
        ListNBT tagMismatches = tag.func_150295_c("mismatchList", 10);
        for (int i = 0; i < tagMismatches.size(); ++i) {
            CompoundNBT tagPos = tagMismatches.func_150305_b(i);
            this.mismatches.add(NBTHelper.readBlockPosFromNBT(tagPos));
        }
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        ListNBT tagMismatches = new ListNBT();
        for (BlockPos pos : this.mismatches) {
            CompoundNBT tagPos = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(pos, tagPos);
            tagMismatches.add((Object)tagPos);
        }
        tag.func_218657_a("mismatchList", (INBT)tagMismatches);
    }
}

