/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheIOThread;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class WorldCacheDomain {
    private final ResourceLocation key;
    private Set<SaveKey<? extends CachedWorldData>> knownSaveKeys = new HashSet<SaveKey<? extends CachedWorldData>>();
    private Map<Integer, Map<SaveKey<?>, CachedWorldData>> domainData = new HashMap();

    WorldCacheDomain(ResourceLocation key) {
        this.key = key;
    }

    public <T extends CachedWorldData> SaveKey<T> createSaveKey(String name, Function<SaveKey<T>, T> dataProvider) {
        for (SaveKey<? extends CachedWorldData> key : this.knownSaveKeys) {
            if (!((SaveKey)key).identifier.equalsIgnoreCase(name)) continue;
            return key;
        }
        SaveKey key = new SaveKey(name, dataProvider);
        this.knownSaveKeys.add(key);
        return key;
    }

    @Nullable
    public <T extends CachedWorldData> SaveKey<T> getKey(String identifier) {
        for (SaveKey<? extends CachedWorldData> key : this.knownSaveKeys) {
            if (!((SaveKey)key).identifier.equalsIgnoreCase(identifier)) continue;
            return key;
        }
        return null;
    }

    @Nonnull
    public Set<SaveKey<? extends CachedWorldData>> getKnownSaveKeys() {
        return Collections.unmodifiableSet(this.knownSaveKeys);
    }

    public ResourceLocation getName() {
        return this.key;
    }

    void tick(World world) {
        int dimId = world.func_201675_m().func_186058_p().func_186068_a();
        if (!this.domainData.containsKey(dimId)) {
            return;
        }
        Map<SaveKey<?>, CachedWorldData> dataMap = this.domainData.get(dimId);
        for (SaveKey<? extends CachedWorldData> key : this.getKnownSaveKeys()) {
            if (!dataMap.containsKey(key)) continue;
            dataMap.get(key).updateTick(world);
        }
    }

    @Nullable
    <T extends CachedWorldData> T getCachedData(int dimId, SaveKey<T> key) {
        if (!this.domainData.containsKey(dimId)) {
            return null;
        }
        return (T)this.domainData.get(dimId).get(key);
    }

    Collection<Integer> getUsedWorlds() {
        return this.domainData.keySet();
    }

    @Nonnull
    public <T extends CachedWorldData> T getData(IWorld world, SaveKey<T> key) {
        T data = this.getFromCache(world, key);
        if (data == null) {
            data = WorldCacheIOThread.loadNow(this, world, key);
            int dimId = world.func_201675_m().func_186058_p().func_186068_a();
            this.domainData.computeIfAbsent(dimId, i -> new HashMap()).put(key, data);
        }
        return data;
    }

    @Nullable
    private <T extends CachedWorldData> T getFromCache(IWorld world, SaveKey<T> key) {
        int dimId = world.func_201675_m().func_186058_p().func_186068_a();
        if (!this.domainData.containsKey(dimId)) {
            return null;
        }
        Map<SaveKey<?>, CachedWorldData> dataMap = this.domainData.get(dimId);
        return (T)dataMap.get(key);
    }

    public File getSaveDirectory() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return null;
        }
        File dataDir = server.func_71254_M().func_186352_b(server.func_71270_I(), this.key.func_110624_b());
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        return dataDir;
    }

    void clear() {
        this.domainData.clear();
    }

    public static class SaveKey<T extends CachedWorldData> {
        private final String identifier;
        private final Function<SaveKey<T>, T> instanceProvider;

        private SaveKey(String identifier, Function<SaveKey<T>, T> provider) {
            this.identifier = identifier;
            this.instanceProvider = provider;
        }

        public T getNewInstance(SaveKey<T> key) {
            return (T)((CachedWorldData)this.instanceProvider.apply(key));
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

