/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data.base;

import com.google.common.io.Files;
import hellfirepvp.observerlib.ObserverLib;
import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;

public abstract class GlobalWorldData
extends CachedWorldData {
    private boolean dirty = false;
    private final String saveFileName;

    protected GlobalWorldData(WorldCacheDomain.SaveKey<?> key) {
        super(key);
        this.saveFileName = key.getIdentifier() + ".dat";
    }

    public final void markDirty() {
        this.dirty = true;
    }

    private File getSaveFile(File directory) {
        return directory.toPath().resolve(this.saveFileName).toFile();
    }

    @Override
    public final void writeData(File baseDirectory, File backupDirectory) throws IOException {
        File saveFile;
        if (!baseDirectory.exists()) {
            baseDirectory.mkdirs();
        }
        if (!backupDirectory.exists()) {
            backupDirectory.mkdirs();
        }
        if ((saveFile = this.getSaveFile(baseDirectory)).exists()) {
            try {
                Files.copy((File)saveFile, (File)this.getSaveFile(backupDirectory));
            }
            catch (Exception exc) {
                ObserverLib.log.info("Copying '" + this.getSaveKey().getIdentifier() + "' 's actual file to its backup file failed!");
                exc.printStackTrace();
            }
        } else {
            saveFile.createNewFile();
        }
        CompoundNBT data = new CompoundNBT();
        this.writeToNBT(data);
        CompressedStreamTools.func_74795_b((CompoundNBT)data, (File)saveFile);
    }

    @Override
    public final void readData(File baseDirectory) throws IOException {
        this.readFromNBT(CompressedStreamTools.func_74797_a((File)this.getSaveFile(baseDirectory)));
    }

    public abstract void writeToNBT(CompoundNBT var1);

    public abstract void readFromNBT(CompoundNBT var1);

    @Override
    public final boolean needsSaving() {
        return this.dirty;
    }

    @Override
    public final void markSaved() {
        this.dirty = false;
    }
}

