/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.event;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.handler.PickupHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class ItemEntityEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack)) {
            String command;
            CarryOnOverride override;
            player.getPersistentData().func_82580_o("carrySlot");
            event.setUseBlock(Event.Result.DENY);
            if (!player.field_70170_p.field_72995_K && (override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandPlace()) != null) {
                player.func_184102_h().func_195571_aL().func_197059_a(player.func_184102_h().func_195573_aM(), "/execute as " + player.func_146103_bH().getName() + " run " + command);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemDropped(EntityJoinWorldEvent event) {
        ItemEntity eitem;
        ItemStack stack;
        Item item;
        Entity e = event.getEntity();
        World world = event.getWorld();
        if (e instanceof ItemEntity && (item = (stack = (eitem = (ItemEntity)e).func_92059_d()).func_77973_b()) == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack)) {
            BlockPos pos = eitem.func_180425_c();
            Entity entity = ItemCarryonEntity.getEntity(stack, world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            world.func_217376_c(entity);
            ItemCarryonEntity.clearEntityData(stack);
            eitem.func_92058_a(ItemStack.field_190927_a);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof ServerPlayerEntity)) return;
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        World world = event.getWorld();
        Entity entity = event.getTarget();
        BlockPos pos = entity.func_180425_c();
        if (main.func_190926_b() && off.func_190926_b() && CarryOnKeybinds.isKeyPressed(player)) {
            ItemStack stack = new ItemStack((IItemProvider)RegistrationHandler.itemEntity);
            if (entity.field_70172_ad != 0) return;
            if (entity instanceof AnimalEntity) {
                ((AnimalEntity)entity).func_110160_i(true, true);
            }
            if (!PickupHandler.canPlayerPickUpEntity(player, entity)) return;
            if (!ItemCarryonEntity.storeEntityData(entity, world, stack)) return;
            LazyOptional handler = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            handler.ifPresent(hand -> {
                for (int i = 0; i < hand.getSlots(); ++i) {
                    hand.extractItem(i, 64, false);
                }
            });
            CarryOnOverride override = ScriptChecker.inspectEntity(entity);
            int overrideHash = 0;
            if (override != null) {
                overrideHash = override.hashCode();
            }
            ItemEvents.sendPacket(player, player.field_71071_by.field_70461_c, overrideHash);
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_70606_j(0.0f);
            }
            entity.func_70107_b(entity.func_226277_ct_(), 0.0, entity.func_226281_cx_());
            entity.func_70106_y();
            player.func_184611_a(Hand.MAIN_HAND, stack);
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.FAIL);
            return;
        }
        if (main.func_190926_b()) return;
        if (main.func_77973_b() != RegistrationHandler.itemEntity) return;
        if (!ItemCarryonEntity.hasEntityData(main)) return;
        if (CarryOnKeybinds.isKeyPressed(player)) return;
        if ((Boolean)Configs.Settings.stackableEntities.get() == false) return;
        Entity entityHeld = ItemCarryonEntity.getEntity(main, world);
        if (entity.field_70172_ad != 0) return;
        if (!(entityHeld instanceof LivingEntity)) return;
        if (world.field_72995_K) return;
        if (entityHeld.func_110124_au() == entity.func_110124_au()) return;
        if (entityHeld.func_70089_S()) return;
        if (entity.func_70089_S()) return;
        double sizeHeldEntity = entityHeld.func_213302_cg() * entityHeld.func_213311_cf();
        double distance = pos.func_177951_i((Vec3i)player.func_180425_c());
        Entity lowestEntity = entity.func_184208_bv();
        int numPassengers = ItemEntityEvents.getAllPassengers(lowestEntity);
        if (numPassengers >= (Integer)Configs.Settings.maxEntityStackLimit.get() - 1) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187679_dF, SoundCategory.PLAYERS, 0.5f, 1.5f);
            return;
        }
        Entity topEntity = ItemEntityEvents.getTopPassenger(lowestEntity);
        if (((Boolean)Configs.Settings.useWhitelistStacking.get()).booleanValue()) {
            if (!ListHandler.isStackingAllowed(topEntity)) return;
        } else if (ListHandler.isStackingForbidden(topEntity)) return;
        double sizeEntity = topEntity.func_213302_cg() * topEntity.func_213311_cf();
        if (!(((Boolean)Configs.Settings.entitySizeMattersStacking.get()).booleanValue() && sizeHeldEntity <= sizeEntity || !((Boolean)Configs.Settings.entitySizeMattersStacking.get()).booleanValue())) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187679_dF, SoundCategory.PLAYERS, 0.5f, 1.5f);
            return;
        }
        if (topEntity instanceof HorseEntity) {
            HorseEntity horse = (HorseEntity)topEntity;
            horse.func_110234_j(true);
        }
        if (distance < 6.0) {
            double tempX = entity.func_226277_ct_();
            double tempY = entity.func_226278_cu_();
            double tempZ = entity.func_226281_cx_();
            entityHeld.func_70107_b(tempX, tempY + 2.6, tempZ);
            world.func_217376_c(entityHeld);
            entityHeld.func_184205_a(topEntity, false);
            entityHeld.func_70634_a(tempX, tempY, tempZ);
        } else {
            entityHeld.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            world.func_217376_c(entityHeld);
            entityHeld.func_184205_a(topEntity, false);
        }
        ItemCarryonEntity.clearEntityData(main);
        player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        ItemEvents.sendPacket(player, 9, 0);
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.FAIL);
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187726_cu, SoundCategory.PLAYERS, 0.5f, 1.5f);
    }

    public static int getAllPassengers(Entity entity) {
        int passengers = 0;
        while (entity.func_184207_aI()) {
            List pass = entity.func_184188_bt();
            if (pass.isEmpty()) continue;
            entity = (Entity)pass.get(0);
            ++passengers;
        }
        return passengers;
    }

    public static Entity getTopPassenger(Entity entity) {
        Entity top = entity;
        while (entity.func_184207_aI()) {
            List pass = entity.func_184188_bt();
            if (pass.isEmpty()) continue;
            top = entity = (Entity)pass.get(0);
        }
        return top;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        ItemStack main = entity.func_184614_ca();
        if (!main.func_190926_b() && main.func_77973_b() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(main)) {
            Entity contained;
            BlockPos pos = entity.func_180425_c();
            BlockPos below = pos.func_177972_a(Direction.DOWN);
            if ((world.func_180495_p(pos).func_185904_a() == Material.field_151586_h || world.func_180495_p(below).func_185904_a() == Material.field_151586_h) && (contained = ItemCarryonEntity.getEntity(main, world)) != null) {
                float height = contained.func_213311_cf();
                float width = contained.func_213311_cf();
                entity.func_70024_g(0.0, -0.01 * (double)height * (double)width, 0.0);
            }
        }
    }
}

