/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptReader;

public class ScriptChecker {
    @Nullable
    public static CarryOnOverride inspectBlock(BlockState state, World world, BlockPos pos, @Nullable CompoundNBT tag) {
        boolean isAllowed;
        if (!((Boolean)Configs.Settings.useScripts.get()).booleanValue()) {
            return null;
        }
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        float resistance = block.func_149638_a();
        CompoundNBT nbt = tag;
        boolean bl = (Boolean)Configs.Settings.useWhitelistBlocks.get() != false ? ListHandler.isAllowed(block) : (isAllowed = !ListHandler.isForbidden(block));
        if (isAllowed) {
            for (CarryOnOverride override : ScriptReader.OVERRIDES.values()) {
                if (!override.isBlock() || !ScriptChecker.matchesAll(override, block, material, hardness, resistance, nbt)) continue;
                return override;
            }
        }
        return null;
    }

    @Nullable
    public static CarryOnOverride inspectEntity(Entity entity) {
        boolean isAllowed;
        if (!((Boolean)Configs.Settings.useScripts.get()).booleanValue()) {
            return null;
        }
        String name = entity.func_200600_R().getRegistryName().toString();
        float height = entity.func_213302_cg();
        float width = entity.func_213311_cf();
        float health = entity instanceof LivingEntity ? ((LivingEntity)entity).func_110143_aJ() : 0.0f;
        CompoundNBT tag = new CompoundNBT();
        entity.deserializeNBT(tag);
        boolean bl = (Boolean)Configs.Settings.useWhitelistEntities.get() != false ? ListHandler.isAllowed(entity) : (isAllowed = !ListHandler.isForbidden(entity));
        if (isAllowed) {
            for (CarryOnOverride override : ScriptReader.OVERRIDES.values()) {
                if (!override.isEntity() || !ScriptChecker.matchesAll(override, name, height, width, health, tag)) continue;
                return override;
            }
        }
        return null;
    }

    public static boolean matchesAll(CarryOnOverride override, String name, float height, float width, float health, CompoundNBT tag) {
        boolean matchname = override.getTypeNameEntity() == null ? true : name.equals(override.getTypeNameEntity());
        boolean matchheight = ScriptParseHelper.matches(height, override.getTypeHeight());
        boolean matchwidth = ScriptParseHelper.matches(width, override.getTypeWidth());
        boolean matchhealth = ScriptParseHelper.matches(health, override.getTypeHealth());
        boolean matchnbt = ScriptParseHelper.matches(tag, override.getTypeEntityTag());
        return matchname && matchheight && matchwidth && matchhealth && matchnbt;
    }

    public static boolean matchesAll(CarryOnOverride override, Block block, Material material, float hardness, float resistance, CompoundNBT nbt) {
        boolean matchnbt = ScriptParseHelper.matches(nbt, override.getTypeBlockTag());
        boolean matchblock = ScriptParseHelper.matches(block, override.getTypeNameBlock());
        boolean matchmaterial = ScriptParseHelper.matches(material, override.getTypeMaterial());
        boolean matchhardness = ScriptParseHelper.matches(hardness, override.getTypeHardness());
        boolean matchresistance = ScriptParseHelper.matches(resistance, override.getTypeResistance());
        return matchnbt && matchblock && matchmaterial && matchhardness && matchresistance;
    }

    public static boolean fulfillsConditions(CarryOnOverride override, PlayerEntity player) {
        AdvancementManager manager = ((ServerPlayerEntity)player).field_71133_b.func_191949_aK();
        Advancement adv = manager.func_192778_a(new ResourceLocation(override.getConditionAchievement() == null ? "" : override.getConditionAchievement()));
        boolean achievement = adv == null ? true : ((ServerPlayerEntity)player).func_192039_O().func_192747_a(adv).func_192105_a();
        boolean gamemode = ScriptParseHelper.matches(((ServerPlayerEntity)player).field_71134_c.func_73081_b().func_77148_a(), override.getConditionGamemode());
        boolean gamestage = true;
        if (ModList.get().isLoaded("gamestages") && override.getConditionGamestage() != null) {
            try {
                Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                Class<?> iStageData = Class.forName("net.darkhax.gamestages.data.IStageData");
                Method getPlayerData = ObfuscationReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", (Class[])new Class[]{PlayerEntity.class});
                Method hasStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasStage", (Class[])new Class[]{String.class});
                Object stageData = getPlayerData.invoke(null, player);
                String condition = override.getConditionGamestage();
                gamestage = (Boolean)hasStage.invoke(stageData, condition);
            }
            catch (Exception e) {
                try {
                    Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                    Class<?> iStageData = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                    Method getStageData = ObfuscationReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", (Class[])new Class[]{PlayerEntity.class});
                    Method hasUnlockedStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasUnlockedStage", (Class[])new Class[]{String.class});
                    Object stageData = getStageData.invoke(null, player);
                    String condition = override.getConditionGamestage();
                    gamestage = (Boolean)hasUnlockedStage.invoke(stageData, condition);
                }
                catch (Exception playerDataHandler) {
                    // empty catch block
                }
            }
        }
        boolean position = ScriptParseHelper.matches(player.func_180425_c(), override.getConditionPosition());
        boolean xp = ScriptParseHelper.matches(player.field_71068_ca, override.getConditionXp());
        boolean scoreboard = ScriptParseHelper.matchesScore(player, override.getConditionScoreboard());
        boolean effects = ScriptParseHelper.hasEffects(player, override.getConditionEffects());
        return achievement && gamemode && gamestage && position && xp && scoreboard && effects;
    }

    @Nullable
    public static CarryOnOverride getOverride(PlayerEntity player) {
        CompoundNBT tag = player.getPersistentData();
        if (tag != null && tag.func_74764_b("overrideKey")) {
            int key = tag.func_74762_e("overrideKey");
            return ScriptReader.OVERRIDES.get(key);
        }
        return null;
    }

    public static void setCarryOnOverride(PlayerEntity player, int i) {
        CompoundNBT tag = player.getPersistentData();
        if (tag != null) {
            tag.func_74768_a("overrideKey", i);
        }
    }
}

