/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.capability;

import codechicken.lib.math.MathHelper;
import codechicken.lib.util.Object2IntPair;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class CapabilityCache {
    private final Map<Capability<?>, Object2IntPair<LazyOptional<?>>> selfCache = new HashMap();
    private final EnumMap<Direction, Map<Capability<?>, Object2IntPair<LazyOptional<?>>>> sideCache = new EnumMap(Direction.class);
    private World world;
    private BlockPos pos;
    private int ticks;
    private int waitTicks = 100;

    public CapabilityCache() {
    }

    public CapabilityCache(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setWaitTicks(int ticks) {
        this.waitTicks = ticks;
    }

    public void tick() {
        ++this.ticks;
    }

    public void setWorldPos(World world, BlockPos pos) {
        this.clear();
        this.world = world;
        this.pos = pos;
    }

    public void clear() {
        this.selfCache.clear();
        Arrays.stream(Direction.field_82609_l).map(this::getCacheForSide).forEach(Map::clear);
    }

    public void onNeighborChanged(BlockPos from) {
        if (this.world == null || this.pos == null) {
            return;
        }
        BlockPos offset = from.func_177973_b((Vec3i)this.pos);
        int diff = MathHelper.absSum(offset);
        int side = MathHelper.toSide(offset);
        if (side < 0 || diff != 1) {
            return;
        }
        Direction sideChanged = Direction.field_82609_l[side];
        Iterables.concat(this.selfCache.entrySet(), this.getCacheForSide(sideChanged).entrySet()).forEach(entry -> {
            Object2IntPair pair = (Object2IntPair)entry.getValue();
            if (pair.getKey() != null && !((LazyOptional)pair.getKey()).isPresent()) {
                pair.setKey(null);
                pair.setValue(this.ticks);
            }
        });
    }

    public <T> T getCapabilityOr(Capability<T> capability, Direction to, NonNullSupplier<T> default_) {
        return (T)this.getCapability(capability, to).orElseGet(default_);
    }

    public <T> T getCapabilityOr(Capability<T> capability, Direction to, T default_) {
        return (T)this.getCapability(capability, to).orElse(default_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction to) {
        Objects.requireNonNull(capability, "Null capability.");
        if (this.world == null || this.pos == null) {
            return LazyOptional.empty().cast();
        }
        Map<Capability<?>, Object2IntPair<LazyOptional<?>>> sideCache = this.getCacheForSide(to);
        Object2IntPair<LazyOptional<?>> cache = sideCache.get(capability);
        if (cache == null) {
            cache = new Object2IntPair<Object>(null, this.ticks);
            sideCache.put(capability, cache);
            return this.tryReCache(capability, to, cache).cast();
        }
        LazyOptional<?> lookup = cache.getKey();
        if (lookup == null || !lookup.isPresent()) {
            return this.tryReCache(capability, to, cache).cast();
        }
        return lookup.cast();
    }

    private LazyOptional<?> tryReCache(Capability<?> capability, Direction to, Object2IntPair<LazyOptional<?>> cache) {
        boolean isFirst;
        boolean bl = isFirst = cache.getKey() == null;
        if (!(!isFirst && cache.getKey().isPresent() || !isFirst && cache.getValue() + this.waitTicks > this.ticks)) {
            LazyOptional<?> lookup = this.requestCapability(capability, to);
            if (lookup.isPresent()) {
                cache.setKey(lookup);
                cache.setValue(this.ticks);
                lookup.addListener(l -> {
                    cache.setKey(LazyOptional.empty());
                    cache.setValue(this.ticks);
                });
            } else {
                cache.setKey(LazyOptional.empty());
                cache.setValue(this.ticks);
            }
        }
        return cache.getKey();
    }

    private LazyOptional<?> requestCapability(Capability<?> capability, Direction to) {
        Direction inverse;
        TileEntity tile = this.world.func_175625_s(this.pos.func_177972_a(to));
        Direction direction = inverse = to == null ? null : to.func_176734_d();
        if (tile != null) {
            return tile.getCapability(capability, inverse);
        }
        return LazyOptional.empty();
    }

    private Map<Capability<?>, Object2IntPair<LazyOptional<?>>> getCacheForSide(Direction side) {
        if (side == null) {
            return this.selfCache;
        }
        return this.sideCache.computeIfAbsent(side, s -> new HashMap());
    }
}

