/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import codechicken.lib.internal.command.EntityTypeArgument;
import codechicken.lib.math.MathHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class CountCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"count").requires(e -> e.func_197034_c(2))).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(ctx -> {
            EntityType<?> entityType = EntityTypeArgument.getEntityType((CommandContext<CommandSource>)ctx, "entity");
            return CountCommand.countAllEntities((CommandContext<CommandSource>)ctx, e -> e.equals(entityType));
        }))).executes(ctx -> CountCommand.countAllEntities((CommandContext<CommandSource>)ctx, e -> true))));
    }

    private static int countAllEntities(CommandContext<CommandSource> ctx, Predicate<EntityType<?>> predicate) {
        CommandSource source = (CommandSource)ctx.getSource();
        ServerWorld world = source.func_197023_e();
        ServerChunkProvider provider = world.func_72863_F();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        counts.defaultReturnValue(0);
        world.getEntities().filter(e -> predicate.test(e.func_200600_R())).filter(e -> provider.func_73149_a(MathHelper.floor(e.func_226277_ct_()) >> 4, MathHelper.floor(e.func_226281_cx_()) >> 4)).forEach(arg_0 -> CountCommand.lambda$countAllEntities$7((Object2IntMap)counts, arg_0));
        ArrayList<EntityType> order = new ArrayList<EntityType>((Collection<EntityType>)counts.keySet());
        order.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)counts).getInt(arg_0)));
        int total = 0;
        for (EntityType type : order) {
            int count = counts.getInt((Object)type);
            String name = type.getRegistryName().toString();
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + name + TextFormatting.RESET + " x " + TextFormatting.AQUA + count), false);
            total += count;
        }
        if (order.size() == 0) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("ccl.commands.count.fail", new Object[0]), false);
        } else if (order.size() > 1) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("ccl.commands.count.total", new Object[]{TextFormatting.AQUA.toString() + total + TextFormatting.RESET}), false);
        }
        return total;
    }

    private static /* synthetic */ void lambda$countAllEntities$7(Object2IntMap counts, Entity e) {
        int count = counts.getInt((Object)e.func_200600_R());
        counts.put((Object)e.func_200600_R(), count + 1);
    }
}

