/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.math;

import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class MathHelper {
    public static final double phi = 1.618033988749894;
    public static final double pi = Math.PI;
    public static final double todeg = 57.29577951308232;
    public static final double torad = 0.017453292519943;
    public static final double sqrt2 = 1.414213562373095;
    @Deprecated
    public static double[] SIN_TABLE = new double[65536];

    @Deprecated
    public static double sin(double d) {
        return Math.sin(d);
    }

    @Deprecated
    public static double cos(double d) {
        return Math.cos(d);
    }

    public static float approachLinear(float a, float b, float max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static double approachLinear(double a, double b, double max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static float interpolate(float a, float b, float d) {
        return a + (b - a) * d;
    }

    public static double interpolate(double a, double b, double d) {
        return a + (b - a) * d;
    }

    public static double approachExp(double a, double b, double ratio) {
        return a + (b - a) * ratio;
    }

    public static double approachExp(double a, double b, double ratio, double cap) {
        double d = (b - a) * ratio;
        if (Math.abs(d) > cap) {
            d = Math.signum(d) * cap;
        }
        return a + d;
    }

    public static double retreatExp(double a, double b, double c, double ratio, double kick) {
        double d = (Math.abs(c - a) + kick) * ratio;
        if (d > Math.abs(b - a)) {
            return b;
        }
        return a + Math.signum(b - a) * d;
    }

    public static double clip(double value, double min, double max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static float clip(float value, float min, float max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static int clip(int value, int min, int max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static double map(double valueIn, double inMin, double inMax, double outMin, double outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static float map(float valueIn, float inMin, float inMax, float outMin, float outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static double round(double number, double multiplier) {
        return (double)Math.round(number * multiplier) / multiplier;
    }

    public static float round(float number, float multiplier) {
        return (float)Math.round(number * multiplier) / multiplier;
    }

    public static boolean between(double min, double value, double max) {
        return min <= value && value <= max;
    }

    public static int approachExpI(int a, int b, double ratio) {
        int r = (int)Math.round(MathHelper.approachExp(a, b, ratio));
        return r == a ? b : r;
    }

    public static int retreatExpI(int a, int b, int c, double ratio, int kick) {
        int r = (int)Math.round(MathHelper.retreatExp(a, b, c, ratio, kick));
        return r == a ? b : r;
    }

    public static int floor(double d) {
        return net.minecraft.util.math.MathHelper.func_76128_c((double)d);
    }

    public static int floor(float d) {
        return net.minecraft.util.math.MathHelper.func_76141_d((float)d);
    }

    public static int ceil(double d) {
        return net.minecraft.util.math.MathHelper.func_76143_f((double)d);
    }

    public static int ceil(float d) {
        return net.minecraft.util.math.MathHelper.func_76123_f((float)d);
    }

    public static float sqrt(float f) {
        return net.minecraft.util.math.MathHelper.func_76129_c((float)f);
    }

    public static float sqrt(double f) {
        return net.minecraft.util.math.MathHelper.func_76133_a((double)f);
    }

    public static int roundAway(double d) {
        return (int)(d < 0.0 ? Math.floor(d) : Math.ceil(d));
    }

    public static int compare(int a, int b) {
        return Integer.compare(a, b);
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static BlockPos min(Vec3i pos1, Vec3i pos2) {
        return new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos max(Vec3i pos1, Vec3i pos2) {
        return new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static int absSum(BlockPos pos) {
        return Math.abs(pos.func_177958_n()) + Math.abs(pos.func_177956_o()) + Math.abs(pos.func_177952_p());
    }

    public static boolean isAxial(BlockPos pos) {
        return pos.func_177958_n() == 0 ? pos.func_177956_o() == 0 || pos.func_177952_p() == 0 : pos.func_177956_o() == 0 && pos.func_177952_p() == 0;
    }

    public static int toSide(BlockPos pos) {
        Direction side = MathHelper.getSide(pos);
        return side == null ? -1 : side.func_176745_a();
    }

    public static Direction getSide(BlockPos pos) {
        if (!MathHelper.isAxial(pos)) {
            return null;
        }
        if (pos.func_177956_o() < 0) {
            return Direction.DOWN;
        }
        if (pos.func_177956_o() > 0) {
            return Direction.UP;
        }
        if (pos.func_177952_p() < 0) {
            return Direction.NORTH;
        }
        if (pos.func_177952_p() > 0) {
            return Direction.SOUTH;
        }
        if (pos.func_177958_n() < 0) {
            return Direction.WEST;
        }
        if (pos.func_177958_n() > 0) {
            return Direction.EAST;
        }
        return null;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = Math.sin((double)i / 65536.0 * 2.0 * Math.PI);
        }
        MathHelper.SIN_TABLE[0] = 0.0;
        MathHelper.SIN_TABLE[16384] = 1.0;
        MathHelper.SIN_TABLE[32768] = 0.0;
        MathHelper.SIN_TABLE[49152] = 1.0;
    }
}

