/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.vec.Vector3;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class DistanceRayTraceResult
extends BlockRayTraceResult
implements Comparable<DistanceRayTraceResult> {
    public double dist;

    public DistanceRayTraceResult(Vector3 hitVec, Direction faceIn, BlockPos posIn, boolean isInside, Object data, double dist) {
        this(false, hitVec.vec3(), faceIn, posIn, isInside, data, dist);
    }

    public DistanceRayTraceResult(Vec3d hitVec, Direction faceIn, BlockPos posIn, boolean isInside, Object data, double dist) {
        this(false, hitVec, faceIn, posIn, isInside, data, dist);
    }

    protected DistanceRayTraceResult(boolean isMissIn, Vec3d hitVec, Direction faceIn, BlockPos posIn, boolean isInside, Object data, double dist) {
        super(isMissIn, hitVec, faceIn, posIn, isInside);
        this.setData(data);
        this.dist = dist;
    }

    public void setData(Object data) {
        if (data instanceof Integer) {
            this.subHit = (Integer)data;
        }
        this.hitInfo = data;
    }

    public DistanceRayTraceResult withFace(Direction newFace) {
        return new DistanceRayTraceResult(this.func_216346_c() == RayTraceResult.Type.MISS, this.func_216347_e(), this.func_216354_b(), this.func_216350_a(), this.func_216353_d(), this.hitInfo, this.dist);
    }

    @Deprecated
    public void offsetHit(BlockPos pos) {
        this.field_72307_f = this.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    @Override
    public int compareTo(DistanceRayTraceResult o) {
        return Double.compare(this.dist, o.dist);
    }

    public String toString() {
        return super.toString().replace("}", "") + ", subHit=" + this.subHit + ", sqDist: " + this.dist + "}";
    }
}

