/*
 * Decompiled with CFR 0.152.
 */
package trackapi.compat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import trackapi.lib.ITrack;

public class MinecraftRail
implements ITrack {
    private static Map<RailShape, Vec3d> vectors = new HashMap<RailShape, Vec3d>();
    private static Map<RailShape, Vec3d> centers = new HashMap<RailShape, Vec3d>();
    private RailShape direction;
    private BlockPos pos;

    public MinecraftRail(World world, BlockPos pos) {
        this.pos = pos;
        BlockState state = world.func_180495_p(pos);
        AbstractRailBlock blockrailbase = (AbstractRailBlock)state.func_177230_c();
        this.direction = blockrailbase.getRailDirection(state, (IBlockReader)world, pos, (AbstractMinecartEntity)new MinecartEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    @Override
    public double getTrackGauge() {
        return 0.632;
    }

    @Override
    public Vec3d getNextPosition(Vec3d currentPosition, Vec3d motion) {
        Vec3d trackMovement = vectors.get(this.direction);
        Vec3d trackCenter = centers.get(this.direction);
        Vec3d posRelativeToCenter = currentPosition.func_72444_a(new Vec3d((Vec3i)this.pos).func_178787_e(trackCenter));
        double distanceToCenter = posRelativeToCenter.func_72433_c();
        boolean trackPosMotionInverted = posRelativeToCenter.func_72438_d(trackMovement) < posRelativeToCenter.func_186678_a(-1.0).func_72438_d(trackMovement);
        boolean trackMotionInverted = motion.func_72438_d(trackMovement) > motion.func_186678_a(-1.0).func_72438_d(trackMovement);
        Vec3d newPosition = new Vec3d((Vec3i)this.pos).func_178787_e(trackCenter);
        newPosition = newPosition.func_178787_e(trackMovement.func_186678_a(trackPosMotionInverted ? -distanceToCenter : distanceToCenter));
        newPosition = newPosition.func_178787_e(trackMovement.func_186678_a(trackMotionInverted ? -motion.func_72433_c() : motion.func_72433_c()));
        return newPosition;
    }

    public static boolean isRail(World world, BlockPos pos) {
        return AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos);
    }

    static {
        Vec3d north = new Vec3d(0.0, 0.0, 1.0);
        Vec3d south = new Vec3d(0.0, 0.0, -1.0);
        Vec3d east = new Vec3d(1.0, 0.0, 0.0);
        Vec3d west = new Vec3d(-1.0, 0.0, 0.0);
        Vec3d ascending = new Vec3d(0.0, 1.0, 0.0);
        vectors.put(RailShape.ASCENDING_EAST, east.func_178787_e(ascending).func_72432_b());
        vectors.put(RailShape.ASCENDING_NORTH, north.func_178787_e(ascending).func_72432_b());
        vectors.put(RailShape.ASCENDING_SOUTH, south.func_178787_e(ascending).func_72432_b());
        vectors.put(RailShape.ASCENDING_WEST, west.func_178787_e(ascending).func_72432_b());
        vectors.put(RailShape.EAST_WEST, east.func_72432_b());
        vectors.put(RailShape.NORTH_EAST, north.func_178787_e(east).func_72432_b());
        vectors.put(RailShape.NORTH_SOUTH, north.func_72432_b());
        vectors.put(RailShape.NORTH_WEST, north.func_178787_e(west).func_72432_b());
        vectors.put(RailShape.SOUTH_EAST, south.func_178787_e(east).func_72432_b());
        vectors.put(RailShape.SOUTH_WEST, south.func_178787_e(west).func_72432_b());
        centers.put(RailShape.ASCENDING_EAST, new Vec3d(0.5, 0.5, 0.5));
        centers.put(RailShape.ASCENDING_NORTH, new Vec3d(0.5, 0.5, 0.5));
        centers.put(RailShape.ASCENDING_SOUTH, new Vec3d(0.5, 0.5, 0.5));
        centers.put(RailShape.ASCENDING_WEST, new Vec3d(0.5, 0.5, 0.5));
        centers.put(RailShape.EAST_WEST, new Vec3d(0.5, 0.1, 0.5));
        centers.put(RailShape.NORTH_EAST, new Vec3d(0.75, 0.1, 0.25));
        centers.put(RailShape.NORTH_SOUTH, new Vec3d(0.5, 0.1, 0.5));
        centers.put(RailShape.NORTH_WEST, new Vec3d(0.25, 0.1, 0.25));
        centers.put(RailShape.SOUTH_EAST, new Vec3d(0.75, 0.1, 0.75));
        centers.put(RailShape.SOUTH_WEST, new Vec3d(0.25, 0.1, 0.75));
    }
}

