/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class DimensionBlockPos {
    public final DimensionType dimension;
    public final BlockPos pos;

    public DimensionBlockPos(int x, int y, int z, DimensionType dim) {
        this.pos = new BlockPos(x, y, z);
        this.dimension = dim == null ? DimensionType.field_223227_a_ : dim;
    }

    public DimensionBlockPos(int x, int y, int z, World w) {
        this(x, y, z, w.func_201675_m().func_186058_p());
    }

    public DimensionBlockPos(BlockPos pos, World w) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), w.func_201675_m().func_186058_p());
    }

    public DimensionBlockPos(BlockPos pos, DimensionType dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public DimensionBlockPos(TileEntity te) {
        this(te.func_174877_v(), te.func_145831_w());
    }

    public DimensionBlockPos(CompoundNBT nbt) {
        this(NBTUtil.func_186861_c((CompoundNBT)nbt), DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(nbt.func_74779_i("dimension"))));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionBlockPos that = (DimensionBlockPos)o;
        return this.dimension.equals(that.dimension) && this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.pos);
    }

    @Nonnull
    public String toString() {
        return "Dimension: " + this.dimension + " Pos: " + super.toString();
    }

    public CompoundNBT toNBT() {
        CompoundNBT ret = NBTUtil.func_186859_a((BlockPos)this.pos);
        ret.func_74778_a("dimension", this.dimension.getRegistryName().toString());
        return ret;
    }
}

