/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.utils.ItemUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class FluidTagInput
implements Predicate<FluidStack> {
    protected final Lazy<Tag<Fluid>> fluidTag;
    protected final int amount;
    protected final CompoundNBT nbtTag;

    public FluidTagInput(Lazy<Tag<Fluid>> fluidTag, int amount, CompoundNBT nbtTag) {
        this.fluidTag = fluidTag;
        this.amount = amount;
        this.nbtTag = nbtTag;
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount, CompoundNBT nbtTag) {
        this((Lazy<Tag<Fluid>>)Lazy.of(() -> new FluidTags.Wrapper(resourceLocation)), amount, nbtTag);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount) {
        this(resourceLocation, amount, null);
    }

    public static FluidTagInput deserialize(JsonElement input) {
        Preconditions.checkArgument((boolean)(input instanceof JsonObject), (Object)"FluidTagWithSize can only be deserialized from a JsonObject");
        JsonObject jsonObject = input.getAsJsonObject();
        ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"nbt")) {
            return new FluidTagInput(resourceLocation, JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount"));
        }
        try {
            CompoundNBT nbt = ItemUtils.parseNbtFromJson(jsonObject.get("nbt"));
            return new FluidTagInput(resourceLocation, JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount"), nbt);
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public static FluidTagInput read(PacketBuffer input) {
        ResourceLocation resourceLocation = input.func_192575_l();
        int amount = input.readInt();
        CompoundNBT nbt = input.readBoolean() ? input.func_150793_b() : null;
        return new FluidTagInput(resourceLocation, amount, nbt);
    }

    public FluidTagInput withAmount(int amount) {
        return new FluidTagInput(this.fluidTag, amount, this.nbtTag);
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStack) {
        return this.testIgnoringAmount(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public boolean testIgnoringAmount(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!((Tag)this.fluidTag.get()).func_199685_a_((Object)fluidStack.getFluid())) {
            return false;
        }
        if (this.nbtTag != null) {
            return fluidStack.hasTag() && fluidStack.getTag().equals((Object)this.nbtTag);
        }
        return true;
    }

    @Nonnull
    public List<FluidStack> getMatchingFluidStacks() {
        Tag tag = (Tag)this.fluidTag.get();
        if (tag == null) {
            return Collections.emptyList();
        }
        return tag.func_199885_a().stream().map(fluid -> new FluidStack(fluid, this.amount, this.nbtTag)).collect(Collectors.toList());
    }

    @Nonnull
    public JsonElement serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tag", ((Tag)this.fluidTag.get()).func_199886_b().toString());
        jsonObject.addProperty("amount", (Number)this.amount);
        if (this.nbtTag != null) {
            jsonObject.addProperty("nbt", this.nbtTag.toString());
        }
        return jsonObject;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidStack getRandomizedExampleStack(int rand) {
        List<FluidStack> all = this.getMatchingFluidStacks();
        return all.get(rand / 20 % all.size());
    }

    public void write(PacketBuffer out) {
        out.func_192572_a(((Tag)this.fluidTag.get()).func_199886_b());
        out.writeInt(this.amount);
        out.writeBoolean(this.nbtTag != null);
        if (this.nbtTag != null) {
            out.func_150786_a(this.nbtTag);
        }
    }
}

