/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class TagUtils {
    public static boolean isInBlockOrItemTag(ItemStack stack, ResourceLocation oreName) {
        if (!TagUtils.isNonemptyBlockOrItemTag(oreName)) {
            return false;
        }
        Tag itemTag = ItemTags.func_199903_a().func_199910_a(oreName);
        if (itemTag != null && itemTag.func_199885_a().contains(stack.func_77973_b())) {
            return true;
        }
        Tag blockTag = BlockTags.func_199896_a().func_199910_a(oreName);
        return blockTag != null && blockTag.func_199885_a().stream().map(IItemProvider::func_199767_j).anyMatch(i -> stack.func_77973_b() == i);
    }

    public static boolean isNonemptyItemTag(ResourceLocation name) {
        Tag t = (Tag)ItemTags.func_199903_a().func_200039_c().get(name);
        return t != null && !t.func_199885_a().isEmpty();
    }

    public static boolean isNonemptyBlockTag(ResourceLocation name) {
        Tag t = (Tag)BlockTags.func_199896_a().func_200039_c().get(name);
        return t != null && !t.func_199885_a().isEmpty();
    }

    public static boolean isNonemptyBlockOrItemTag(ResourceLocation name) {
        return TagUtils.isNonemptyBlockTag(name) || TagUtils.isNonemptyItemTag(name);
    }

    public static NonNullList<ItemStack> getItemsInTag(ResourceLocation name) {
        NonNullList ret = NonNullList.func_191196_a();
        TagUtils.addItemsInTag((NonNullList<ItemStack>)ret, ItemTags.func_199903_a().func_199910_a(name));
        TagUtils.addItemsInTag((NonNullList<ItemStack>)ret, BlockTags.func_199896_a().func_199910_a(name));
        return ret;
    }

    private static <T extends IItemProvider> void addItemsInTag(NonNullList<ItemStack> out, Tag<T> in) {
        if (in != null) {
            in.func_199885_a().stream().map(ItemStack::new).forEach(arg_0 -> out.add(arg_0));
        }
    }

    public static boolean isInPrefixedTag(ItemStack stack, String componentType) {
        return TagUtils.getMatchingPrefix(stack, componentType) != null;
    }

    public static String getMatchingPrefix(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static Collection<ResourceLocation> getMatchingTagNames(ItemStack stack) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>(stack.func_77973_b().getTags());
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b != Blocks.field_150350_a) {
            ret.addAll(b.getTags());
        }
        return ret;
    }

    public static String[] getMatchingPrefixAndRemaining(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                String material = name.func_110623_a().substring(componentType.length());
                if (material.startsWith("/")) {
                    material = material.substring(1);
                }
                if (material.length() <= 0) continue;
                return new String[]{componentType, material};
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return TagUtils.isInPrefixedTag(stack, "ingots/");
    }

    public static boolean isPlate(ItemStack stack) {
        return TagUtils.isInPrefixedTag(stack, "plates/");
    }
}

