/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.font;

import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.font.IEFontRender;
import blusunrize.immersiveengineering.client.font.NixieFontRender;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.fonts.providers.DefaultGlyphProvider;
import net.minecraft.client.gui.fonts.providers.GlyphProviderTypes;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class IEFontReloadListener
extends ReloadListener<Void> {
    protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        return null;
    }

    protected void apply(Void splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        if (ClientProxy.nixieFontOptional == null) {
            ClientProxy.nixieFontOptional = new NixieFontRender(false, new ResourceLocation("immersiveengineering", "nixie_opt"));
            ClientProxy.nixieFont = new NixieFontRender(false, new ResourceLocation("immersiveengineering", "nixie"));
            ClientProxy.itemFont = new IEFontRender(false, new ResourceLocation("immersiveengineering", "item_font"));
        }
        this.reloadFontRender(ClientProxy.itemFont, resourceManagerIn);
        this.reloadFontRender(ClientProxy.nixieFont, resourceManagerIn);
        this.reloadFontRender(ClientProxy.nixieFontOptional, resourceManagerIn);
    }

    private void reloadFontRender(IEFontRender render, IResourceManager resourceManagerIn) {
        ResourceLocation resourcelocation = render.getBaseID();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        ArrayList list = Lists.newArrayList((Object[])new IGlyphProvider[]{new DefaultGlyphProvider()});
        try {
            for (IResource iresource : resourceManagerIn.func_199004_b(new ResourceLocation(resourcelocation.func_110624_b(), "font/" + resourcelocation.func_110623_a() + ".json"))) {
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable2 = null;
                        try {
                            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)((JsonObject)JSONUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class)), (String)"providers");
                            for (int i = jsonarray.size() - 1; i >= 0; --i) {
                                JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonarray.get(i), (String)("providers[" + i + "]"));
                                try {
                                    String s1 = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
                                    GlyphProviderTypes glyphprovidertypes = GlyphProviderTypes.func_211638_a((String)s1);
                                    boolean shouldAdd = glyphprovidertypes == GlyphProviderTypes.LEGACY_UNICODE;
                                    shouldAdd |= !resourcelocation.equals((Object)Minecraft.field_211502_b);
                                    if (!(shouldAdd |= !Minecraft.func_71410_x().func_211821_e())) continue;
                                    list.add(glyphprovidertypes.func_211637_a(jsonobject).func_211246_a(resourceManagerIn));
                                    continue;
                                }
                                catch (RuntimeException runtimeexception) {
                                    IELogger.logger.warn("Unable to read definition '{}' in fonts.json in resourcepack: '{}': {}", (Object)resourcelocation, (Object)iresource.func_199026_d(), (Object)runtimeexception.getMessage());
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (RuntimeException runtimeexception1) {
                    IELogger.logger.warn("Unable to load font '{}' in fonts.json in resourcepack: '{}': {}", (Object)resourcelocation, (Object)iresource.func_199026_d(), (Object)runtimeexception1.getMessage());
                }
            }
        }
        catch (IOException ioexception) {
            IELogger.logger.warn("Unable to load font '{}' in fonts.json: {}", (Object)resourcelocation, (Object)ioexception.getMessage());
        }
        Collections.reverse(list);
        render.func_211568_a(list);
    }
}

