/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MixerTileEntity;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.gui.MixerContainer;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class MixerScreen
extends IEContainerScreen<MixerContainer> {
    private MixerTileEntity tile;

    public MixerScreen(MixerContainer container, PlayerInventory inventoryPlayer, ITextComponent title) {
        super(container, inventoryPlayer, title);
        this.tile = (MixerTileEntity)container.tile;
        this.field_147000_g = 167;
    }

    public void init() {
        super.init();
        this.buttons.clear();
        this.addButton((Widget)new GuiButtonBoolean(this.field_147003_i + 106, this.field_147009_r + 61, 30, 16, "", this.tile.outputAll, "immersiveengineering:textures/gui/mixer.png", 176, 82, 1, btn -> {
            CompoundNBT tag = new CompoundNBT();
            this.tile.outputAll = (Boolean)btn.getState() == false;
            tag.func_74757_a("outputAll", this.tile.outputAll);
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageTileSync(this.tile, tag));
            this.fullInit();
        }));
    }

    @Override
    public void render(int mx, int my, float partial) {
        super.render(mx, my, partial);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (mx >= this.field_147003_i + 76 && mx <= this.field_147003_i + 134 && my >= this.field_147009_r + 11 && my <= this.field_147009_r + 58) {
            float capacity = this.tile.tank.getCapacity();
            if (this.tile.tank.getFluidTypes() == 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("gui.immersiveengineering.empty", new Object[0]));
            } else {
                int fluidUpToNow = 0;
                int lastY = 0;
                int myRelative = this.field_147009_r + 58 - my;
                for (int i = this.tile.tank.getFluidTypes() - 1; i >= 0; --i) {
                    FluidStack fs = this.tile.tank.fluids.get(i);
                    if (fs == null || fs.getFluid() == null) continue;
                    int newY = (int)(47.0f * ((float)(fluidUpToNow += fs.getAmount()) / capacity));
                    if (myRelative >= lastY && myRelative < newY) {
                        ClientUtils.addFluidTooltip(fs, tooltip, (int)capacity);
                        break;
                    }
                    lastY = newY;
                }
            }
        }
        if (mx >= this.field_147003_i + 158 && mx < this.field_147003_i + 165 && my > this.field_147009_r + 22 && my < this.field_147009_r + 68) {
            tooltip.add((ITextComponent)new StringTextComponent(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " IF"));
        }
        if (mx >= this.field_147003_i + 106 && mx <= this.field_147003_i + 136 && my >= this.field_147009_r + 61 && my <= this.field_147009_r + 77) {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.immersiveengineering.config.mixer.output" + (this.tile.outputAll ? "All" : "Single"), new Object[0]));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.font, this.width, this.height);
        }
    }

    protected void func_146976_a(float f, int mx, int my) {
        MatrixStack transform = new MatrixStack();
        transform.func_227860_a_();
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture(IEDataGenerator.rl("textures/gui/mixer.png").toString());
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (PoweredMultiblockTileEntity.MultiblockProcess process : this.tile.processQueue) {
            if (!(process instanceof PoweredMultiblockTileEntity.MultiblockProcessInMachine)) continue;
            float mod = 1.0f - (float)process.processTick / (float)process.maxTicks;
            for (int slot : ((PoweredMultiblockTileEntity.MultiblockProcessInMachine)process).getInputSlots()) {
                int h = (int)Math.max(1.0f, mod * 16.0f);
                this.blit(this.field_147003_i + 24 + slot % 2 * 21, this.field_147009_r + 7 + slot / 2 * 18 + (16 - h), 176, 16 - h, 2, h);
            }
        }
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.field_147003_i + 158, this.field_147009_r + 22 + (46 - stored), this.field_147003_i + 165, this.field_147009_r + 68, -4909824, -10482944);
        float capacity = this.tile.tank.getCapacity();
        int fluidUpToNow = 0;
        int lastY = 0;
        for (int i = this.tile.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = this.tile.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            int newY = (int)(47.0f * ((float)(fluidUpToNow += fs.getAmount()) / capacity));
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)buffers, transform, fs, this.field_147003_i + 76, this.field_147009_r + 58 - newY, 58.0f, newY - lastY);
            lastY = newY;
        }
        buffers.func_228461_a_();
    }
}

