/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterTileEntity;
import blusunrize.immersiveengineering.common.gui.SorterContainer;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class SorterScreen
extends IEContainerScreen<SorterContainer> {
    SorterTileEntity tile;

    public SorterScreen(SorterContainer container, PlayerInventory inventoryPlayer, ITextComponent title) {
        super(container, inventoryPlayer, title);
        this.tile = (SorterTileEntity)container.tile;
        this.field_147000_g = 244;
    }

    @Override
    public void render(int mx, int my, float partial) {
        super.render(mx, my, partial);
        for (Widget button : this.buttons) {
            if (!(button instanceof ButtonSorter) || mx <= button.x || mx >= button.x + 18 || my <= button.y || my >= button.y + 18) continue;
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            int type = ((ButtonSorter)button).type;
            String[] split = I18n.func_135052_a((String)("desc.immersiveengineering.info.filter." + (type == 0 ? "oreDict" : (type == 1 ? "nbt" : "fuzzy"))), (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                tooltip.add(new StringTextComponent(split[i]).func_150255_a(new Style().func_150238_a(i == 0 ? TextFormatting.WHITE : TextFormatting.GRAY)));
            }
            ClientUtils.drawHoveringText(tooltip, mx, my, this.font, this.width, this.height);
        }
    }

    protected void func_146976_a(float f, int mx, int my) {
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int side = 0; side < 6; ++side) {
            int x = this.field_147003_i + 30 + side / 2 * 58;
            int y = this.field_147009_r + 44 + side % 2 * 76;
            String s = I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide." + Direction.func_82600_a((int)side).toString()), (Object[])new Object[0]).substring(0, 1);
            RenderSystem.enableBlend();
            ClientUtils.font().func_175063_a(s, (float)(x - ClientUtils.font().func_78256_a(s) / 2), (float)y, -1429418804);
        }
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
    }

    public void init() {
        super.init();
        this.buttons.clear();
        for (int side = 0; side < 6; ++side) {
            for (int bit = 0; bit < 3; ++bit) {
                int x = this.field_147003_i + 3 + side / 2 * 58 + bit * 18;
                int y = this.field_147009_r + 3 + side % 2 * 76;
                int bitFinal = bit;
                int sideFinal = side;
                ButtonSorter b = new ButtonSorter(x, y, bit, btn -> {
                    int mask = 1 << bitFinal;
                    this.tile.sideFilter[sideFinal] = this.tile.sideFilter[sideFinal] ^ mask;
                    CompoundNBT tag = new CompoundNBT();
                    tag.func_74783_a("sideConfig", this.tile.sideFilter);
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageTileSync(this.tile, tag));
                    this.fullInit();
                });
                b.active = bit == 0 ? this.tile.doOredict(side) : (bit == 1 ? this.tile.doNBT(side) : this.tile.doFuzzy(side));
                this.addButton((Widget)b);
            }
        }
    }

    public static class ButtonSorter
    extends Button {
        int type;
        boolean active = false;

        public ButtonSorter(int x, int y, int type, Button.IPressable handler) {
            super(x, y, 18, 18, "", handler);
            this.type = type;
        }

        public void render(int mx, int my, float partialTicks) {
            if (this.visible) {
                ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.isHovered = mx >= this.x && my >= this.y && mx < this.x + this.width && my < this.y + this.height;
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                this.blit(this.x, this.y, 176 + this.type * 18, this.active ? 3 : 21, this.width, this.height);
            }
        }
    }
}

