/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.CombinedModelData;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

public class ModelConfigurableSides
extends BakedIEModel {
    private static HashMap<String, ITextureNamer> TYPES = new HashMap();
    public static Cache<ModelKey, List<BakedQuad>> modelCache;
    final String name;
    public Map<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> textures;
    static final ItemCameraTransforms defaultTransforms;

    public ModelConfigurableSides(String name, Map<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> textures) {
        this.name = name;
        this.textures = textures;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        EnumMap<Direction, IEEnums.IOSideConfig> config;
        if (extraData.hasProperty(IEProperties.Model.SIDECONFIG)) {
            config = (EnumMap<Direction, IEEnums.IOSideConfig>)extraData.getData(IEProperties.Model.SIDECONFIG);
        } else {
            config = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
            for (Direction d : Direction.field_199792_n) {
                config.put(d, IEEnums.IOSideConfig.NONE);
            }
        }
        assert (config != null);
        ModelKey key = new ModelKey(this.name, config);
        try {
            modelCache.invalidateAll();
            return (List)modelCache.get((Object)key, () -> {
                EnumMap<Direction, TextureAtlasSprite> tex = new EnumMap<Direction, TextureAtlasSprite>(Direction.class);
                for (Direction d : Direction.field_199792_n) {
                    tex.put(d, this.textures.get(d).get(config.get(d)));
                }
                return ModelConfigurableSides.bakeQuads(tex);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ArrayList<IModelData> data = new ArrayList<IModelData>();
        data.add(tileData);
        data.add(super.getModelData(world, pos, state, tileData));
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IConfigurableSides) {
            IEBlockInterfaces.IConfigurableSides confTE = (IEBlockInterfaces.IConfigurableSides)te;
            HashMap<Direction, IEEnums.IOSideConfig> conf = new HashMap<Direction, IEEnums.IOSideConfig>();
            for (Direction d : Direction.field_199792_n) {
                conf.put(d, confTE.getSideConfig(d));
            }
            data.add(new SinglePropertyModelData<Map<Direction, IEEnums.IOSideConfig>>(conf, IEProperties.Model.SIDECONFIG));
        }
        return new CombinedModelData(data.toArray(new IModelData[0]));
    }

    private static List<BakedQuad> bakeQuads(Map<Direction, TextureAtlasSprite> sprites) {
        ArrayList quads = Lists.newArrayListWithExpectedSize((int)6);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Vec3d[] vertices = new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.DOWN, sprites.get(Direction.DOWN), new double[]{0.0, 16.0, 16.0, 0.0}, colour, true));
        vertices = new Vec3d[]{new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.UP, sprites.get(Direction.UP), new double[]{0.0, 0.0, 16.0, 16.0}, colour, false));
        vertices = new Vec3d[]{new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 0.0)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.NORTH, sprites.get(Direction.NORTH), new double[]{0.0, 16.0, 16.0, 0.0}, colour, true));
        vertices = new Vec3d[]{new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 0.0, 1.0)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.SOUTH, sprites.get(Direction.SOUTH), new double[]{16.0, 16.0, 0.0, 0.0}, colour, false));
        vertices = new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 0.0, 1.0)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.WEST, sprites.get(Direction.WEST), new double[]{0.0, 16.0, 16.0, 0.0}, colour, true));
        vertices = new Vec3d[]{new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.EAST, sprites.get(Direction.EAST), new double[]{16.0, 16.0, 0.0, 0.0}, colour, false));
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.textures.get(Direction.DOWN).get((Object)IEEnums.IOSideConfig.NONE);
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return defaultTransforms;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    static {
        TYPES.put("side_top_bottom", new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? side.func_176610_l() : "side";
            }
        });
        TYPES.put("side_vertical", new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? "up" : "side";
            }
        });
        TYPES.put("vertical", new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? "up" : "side";
            }

            @Override
            public String nameFromCfg(Direction side, IEEnums.IOSideConfig cfg) {
                return side.func_176740_k() == Direction.Axis.Y ? cfg.getTextureName() : null;
            }
        });
        TYPES.put("all_same_texture", new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return "side";
            }
        });
        modelCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
        defaultTransforms = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.25f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));
    }

    private static class ModelKey {
        @Nonnull
        final String name;
        @Nonnull
        final Map<Direction, IEEnums.IOSideConfig> config;

        private ModelKey(@Nonnull String name, @Nonnull Map<Direction, IEEnums.IOSideConfig> config) {
            this.name = name;
            this.config = config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelKey modelKey = (ModelKey)o;
            return this.name.equals(modelKey.name) && this.config.equals(modelKey.config);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.config);
        }
    }

    static interface ITextureNamer {
        default public String getTextureName(Direction side, IEEnums.IOSideConfig cfg) {
            String s = this.nameFromSide(side, cfg);
            String c = this.nameFromCfg(side, cfg);
            if (s != null && c != null) {
                return s + "_" + c;
            }
            if (s != null) {
                return s;
            }
            if (c != null) {
                return c;
            }
            return "";
        }

        default public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
            return side.func_176610_l();
        }

        default public String nameFromCfg(Direction side, IEEnums.IOSideConfig cfg) {
            return cfg.getTextureName();
        }
    }

    private static class ConfigSidesModelBase
    implements IModelGeometry<ConfigSidesModelBase> {
        final String name;
        final String type;
        Map<String, Material> textures;

        public ConfigSidesModelBase(String name, String type, Map<String, Material> textures) {
            this.name = name;
            this.type = type;
            this.textures = textures;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            EnumMap<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> tex = new EnumMap<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>>(Direction.class);
            for (Direction f : Direction.field_199792_n) {
                EnumMap<IEEnums.IOSideConfig, TextureAtlasSprite> forSide = new EnumMap<IEEnums.IOSideConfig, TextureAtlasSprite>(IEEnums.IOSideConfig.class);
                for (IEEnums.IOSideConfig cfg : IEEnums.IOSideConfig.values()) {
                    Material rl = this.textures.get(f.func_176610_l() + "_" + cfg.getTextureName());
                    if (rl == null) continue;
                    forSide.put(cfg, spriteGetter.apply(rl));
                }
                tex.put(f, forSide);
            }
            return new ModelConfigurableSides(this.name, tex);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.textures.values();
        }
    }

    public static class Loader
    implements IModelLoader<ConfigSidesModelBase> {
        public static ResourceLocation NAME = new ResourceLocation("immersiveengineering", "conf_sides");

        public void func_195410_a(@Nonnull IResourceManager resourceManager) {
            modelCache.invalidateAll();
        }

        public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
            if (resourcePredicate.test((IResourceType)VanillaResourceType.MODELS) || resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
                this.func_195410_a(resourceManager);
            }
        }

        @Nonnull
        public ConfigSidesModelBase read(@Nonnull JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            String name = modelContents.get("base_name").getAsString();
            String type = modelContents.get("type").getAsString();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ITextureNamer namer = (ITextureNamer)TYPES.get(type);
            for (Direction f : Direction.field_199792_n) {
                for (IEEnums.IOSideConfig cfg : IEEnums.IOSideConfig.values()) {
                    String key = f.func_176610_l() + "_" + cfg.getTextureName();
                    String tex = name + "_" + namer.getTextureName(f, cfg);
                    builder.put((Object)key, (Object)new Material(PlayerContainer.field_226615_c_, new ResourceLocation(tex)));
                }
            }
            return new ConfigSidesModelBase(name, type, (Map<String, Material>)builder.build());
        }
    }
}

