/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.TileRenderUtils;
import blusunrize.immersiveengineering.client.utils.BatchingRenderTypeBuffer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.BottlingMachineTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class BottlingMachineRenderer
extends TileEntityRenderer<BottlingMachineTileEntity> {
    public static DynamicModel<Direction> DYNAMIC;

    public BottlingMachineRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(BottlingMachineTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        BlockPos blockPos = te.func_174877_v();
        BlockState state = te.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.Multiblocks.bottlingMachine) {
            return;
        }
        Direction facing = te.getFacing();
        float pixelHeight = 0.0625f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        IRenderTypeBuffer originalBuffer = bufferIn;
        bufferIn = TileRenderUtils.mirror(te, matrixStack, bufferIn);
        float[][] itemDisplays = new float[te.bottlingProcessQueue.size()][];
        float lift = 0.0f;
        IVertexBuilder solidBuilder = bufferIn.getBuffer(RenderType.func_228639_c_());
        for (int i = 0; i < itemDisplays.length; ++i) {
            float itemX;
            BottlingMachineTileEntity.BottlingProcess process = te.bottlingProcessQueue.get(i);
            if (process == null) continue;
            float processMaxTicks = process.maxProcessTick;
            float transportTime = BottlingMachineTileEntity.getTransportTime(processMaxTicks);
            float liftTime = BottlingMachineTileEntity.getLiftTime(processMaxTicks);
            float fProcess = process.processTick;
            float itemY = 0.0f;
            float itemFill = 0.0f;
            if (fProcess < transportTime) {
                itemX = 0.5f * fProcess / transportTime;
            } else if (fProcess < processMaxTicks - transportTime) {
                itemX = 0.5f;
                if (fProcess < transportTime + liftTime) {
                    lift = (fProcess - transportTime) / liftTime;
                } else if (fProcess < processMaxTicks - (transportTime + liftTime)) {
                    lift = 1.0f;
                    itemFill = (fProcess - (transportTime + liftTime)) / (processMaxTicks - 2.0f * (transportTime + liftTime));
                } else {
                    lift = 1.0f - (fProcess - (processMaxTicks - transportTime - liftTime)) / liftTime;
                    itemFill = 1.0f;
                }
                lift *= 0.125f;
                if (lift > 0.0625f) {
                    itemY += lift - 0.0625f;
                }
            } else {
                itemX = 0.5f + 0.5f * (fProcess - (processMaxTicks - transportTime)) / transportTime;
                itemFill = 1.0f;
            }
            itemDisplays[i] = new float[]{fProcess, (itemX - 0.5f) * 2.5f, itemY - 0.15625f, 1.0f, itemFill};
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)lift, 0.0);
        BottlingMachineRenderer.renderModelPart(matrixStack, solidBuilder, facing, combinedLightIn, combinedOverlayIn, "lift");
        matrixStack.func_227861_a_(0.0, (double)(-lift), 0.0);
        matrixStack.func_227865_b_();
        float dir = facing == Direction.SOUTH ? 180.0f : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -90.0f : 90.0f));
        matrixStack.func_227863_a_(new Quaternion(0.0f, dir, 0.0f, true));
        float scale = 0.0625f;
        FluidStack fs = te.tanks[0].getFluid();
        if (!fs.isEmpty()) {
            float tankWidth = 7.0f;
            matrixStack.func_227860_a_();
            float level = (float)fs.getAmount() / (float)te.tanks[0].getCapacity();
            matrixStack.func_227861_a_(-0.21875, 0.376, 1.21875);
            matrixStack.func_227862_a_(scale, scale, scale);
            matrixStack.func_227861_a_(3.5, 0.0, -3.5);
            float h = level * 9.0f;
            IVertexBuilder builder = originalBuffer.getBuffer(RenderType.func_228645_f_());
            for (int i = 0; i < 4; ++i) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, -3.5);
                ClientUtils.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, 0.0f, 7.0f, h);
                matrixStack.func_227865_b_();
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
            }
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
            ClientUtils.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 180.0f, true));
            matrixStack.func_227861_a_(0.0, 0.0, (double)(-h));
            ClientUtils.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.func_227865_b_();
        }
        for (int i = 0; i < itemDisplays.length; ++i) {
            BottlingMachineTileEntity.BottlingProcess process;
            if (itemDisplays[i] == null || (process = te.bottlingProcessQueue.get(i)) == null) continue;
            ItemStack display = itemDisplays[i][4] == 0.0f || ((ItemStack)process.items.get(1)).func_190926_b() ? (ItemStack)process.items.get(0) : (ItemStack)process.items.get(1);
            scale = 0.4375f;
            matrixStack.func_227861_a_((double)itemDisplays[i][1], (double)itemDisplays[i][2], (double)itemDisplays[i][3]);
            matrixStack.func_227862_a_(scale, scale, scale);
            if (itemDisplays[i][4] == 0.0f) {
                ClientUtils.mc().func_175599_af().func_229110_a_((ItemStack)process.items.get(0), ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
            } else if (itemDisplays[i][4] == 1.0f || !ClientUtils.mc().func_147110_a().isStencilEnabled()) {
                ClientUtils.mc().func_175599_af().func_229110_a_(display, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
            } else {
                float h0 = -0.5f;
                float h1 = h0 + itemDisplays[i][4];
                this.renderItemPart(bufferIn, matrixStack, (ItemStack)process.items.get(0), h0, h1, combinedLightIn, combinedOverlayIn, 0);
                this.renderItemPart(bufferIn, matrixStack, (ItemStack)process.items.get(1), h0, h1, combinedLightIn, combinedOverlayIn, 1);
            }
            matrixStack.func_227862_a_(1.0f / scale, 1.0f / scale, 1.0f / scale);
            matrixStack.func_227861_a_((double)(-itemDisplays[i][1]), (double)(-itemDisplays[i][2]), (double)(-itemDisplays[i][3]));
        }
        matrixStack.func_227865_b_();
    }

    public static void renderModelPart(MatrixStack matrixStack, IVertexBuilder builder, Direction facing, int combinedLightIn, int combinedOverlayIn, String ... parts) {
        SinglePropertyModelData<IEProperties.IEObjState> data = new SinglePropertyModelData<IEProperties.IEObjState>(new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts)), IEProperties.Model.IE_OBJ_STATE);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = DYNAMIC.getNullQuads(facing, IEBlocks.Multiblocks.bottlingMachine.func_176223_P(), data);
        ClientUtils.renderModelTESRFast(quads, builder, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    private void renderItemPart(IRenderTypeBuffer baseBuffer, MatrixStack matrix, ItemStack item, float minY, float maxY, int combinedLightIn, int combinedOverlayIn, int ref) {
        MatrixStack innerStack = new MatrixStack();
        innerStack.func_227866_c_().func_227870_a_().func_226595_a_(matrix.func_227866_c_().func_227870_a_());
        innerStack.func_227866_c_().func_227872_b_().func_226118_b_(matrix.func_227866_c_().func_227872_b_());
        IRenderTypeBuffer stencilWrapper = IERenderTypes.wrapWithStencil(baseBuffer, vertexBuilder -> {
            innerStack.func_227860_a_();
            innerStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f - ClientUtils.mc().func_175598_ae().field_217783_c.func_216778_f(), true));
            ClientUtils.renderBox(vertexBuilder, innerStack, -0.5f, minY, -0.5f, 0.5f, maxY, 0.5f);
            innerStack.func_227865_b_();
        }, "min" + minY + "max" + maxY, ref);
        BatchingRenderTypeBuffer batchBuffer = new BatchingRenderTypeBuffer();
        ClientUtils.mc().func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrix, (IRenderTypeBuffer)batchBuffer);
        batchBuffer.pipe(stencilWrapper);
    }
}

