/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.client.models.obj.IESmartObjModel;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.TileRenderUtils;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullSupplier;

public class BucketWheelRenderer
extends TileEntityRenderer<BucketWheelTileEntity> {
    public static DynamicModel<Void> WHEEL;
    private static final Cache<List<String>, IVertexBufferHolder> CACHED_BUFFERS;

    public BucketWheelRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(BucketWheelTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.formed || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v()) || tile.isDummy()) {
            return;
        }
        HashMap<String, String> texMap = new HashMap<String, String>();
        ArrayList<String> textures = new ArrayList<String>(8);
        NonNullList<ItemStack> nonNullList = tile.digStacks;
        synchronized (nonNullList) {
            for (int i = 0; i < tile.digStacks.size(); ++i) {
                ItemStack stackAtIndex = (ItemStack)tile.digStacks.get(i);
                if (!stackAtIndex.func_190926_b()) {
                    Block b = Block.func_149634_a((Item)stackAtIndex.func_77973_b());
                    BlockState digState = b != Blocks.field_150350_a ? b.func_176223_P() : Blocks.field_150347_e.func_176223_P();
                    IBakedModel digModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(digState);
                    String texture = digModel.func_177554_e().func_195668_m().toString();
                    texMap.put("dig" + i, texture);
                    textures.add(texture);
                    continue;
                }
                textures.add("");
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
        TileRenderUtils.mirror(tile, matrixStack);
        float dir = tile.getFacing() == Direction.SOUTH ? 0.0f : (tile.getFacing() == Direction.NORTH ? 180.0f : (tile.getFacing() == Direction.EAST ? 90.0f : -90.0f));
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), dir, true));
        float rot = tile.rotation + (float)(tile.active ? (Double)IEConfig.MACHINES.excavator_speed.get() * (double)partialTicks : 0.0);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), rot, true));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        try {
            ((IVertexBufferHolder)CACHED_BUFFERS.get(textures, () -> IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> {
                IBakedModel model = WHEEL.get(null);
                BlockState state = IEBlocks.Multiblocks.bucketWheel.func_176223_P();
                ArrayList list = Lists.newArrayList((Object[])new String[]{"bucketWheel"});
                list.addAll(texMap.keySet());
                IEProperties.IEObjState objState = new IEProperties.IEObjState(IEProperties.VisibilityList.show(list));
                if (model instanceof IESmartObjModel) {
                    return ((IESmartObjModel)model).getQuads(state, objState, texMap, true, (IModelData)EmptyModelData.INSTANCE);
                }
                return model.getQuads(state, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
            })))).render(RenderType.func_228639_c_(), combinedLightIn, combinedOverlayIn, bufferIn, matrixStack, tile.getIsMirrored());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        matrixStack.func_227865_b_();
    }

    public static void reset() {
        CACHED_BUFFERS.invalidateAll();
    }

    static {
        CACHED_BUFFERS = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.MINUTES).removalListener(rem -> ((IVertexBufferHolder)rem.getValue()).reset()).build();
    }
}

