/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.DynamicModelLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public abstract class DynamicModel<T> {
    private static final Random RAND = new Random();

    public abstract IBakedModel get(T var1);

    public static DynamicModel<Void> createSimple(ResourceLocation model, String key, ModelType type) {
        return new SimpleDynamicModel(model, key, type);
    }

    public static DynamicModel<Direction> createSided(ResourceLocation model, String key, ModelType type) {
        return new SidedDynamicModel(model, key, type);
    }

    public List<BakedQuad> getNullQuads(T key, BlockState state) {
        return this.getNullQuads(key, state, (IModelData)EmptyModelData.INSTANCE);
    }

    public List<BakedQuad> getNullQuads(T key, BlockState state, IModelData data) {
        return this.get(key).getQuads(state, null, RAND, data);
    }

    private static DynamicModelLoader.ModelRequest getRequest(ModelType type, ResourceLocation loc, int rotY) {
        switch (type) {
            case OBJ: {
                return DynamicModelLoader.ModelRequest.obj(loc, rotY);
            }
            case IE_OBJ: {
                return DynamicModelLoader.ModelRequest.ieObj(loc, rotY);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum ModelType {
        OBJ,
        IE_OBJ;

    }

    private static class SimpleDynamicModel
    extends DynamicModel<Void> {
        private final ModelResourceLocation name;

        private SimpleDynamicModel(ResourceLocation name, String desc, ModelType type) {
            ResourceLocation baseLoc = new ResourceLocation("immersiveengineering", "dynamic/" + desc);
            this.name = new ModelResourceLocation(baseLoc, "");
            DynamicModelLoader.requestModel(DynamicModel.getRequest(type, name, 0), this.name);
        }

        @Override
        public IBakedModel get(Void key) {
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            return blockRenderer.func_175023_a().func_178126_b().func_174953_a(this.name);
        }
    }

    private static class SidedDynamicModel
    extends DynamicModel<Direction> {
        private final Map<Direction, ModelResourceLocation> names = new HashMap<Direction, ModelResourceLocation>();

        private SidedDynamicModel(ResourceLocation name, String desc, ModelType type) {
            ResourceLocation baseLoc = new ResourceLocation("immersiveengineering", "dynamic/" + desc);
            for (Direction d : Direction.field_176754_o) {
                this.names.put(d, new ModelResourceLocation(baseLoc, d.func_176610_l()));
                DynamicModelLoader.requestModel(DynamicModel.getRequest(type, name, (int)d.func_185119_l() + 180), this.names.get(d));
            }
        }

        @Override
        public IBakedModel get(Direction key) {
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            return blockRenderer.func_175023_a().func_178126_b().func_174953_a(this.names.get(key));
        }
    }
}

