/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.utils.InvertingVertexBuffer;
import blusunrize.immersiveengineering.common.IEConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.common.util.NonNullSupplier;
import org.lwjgl.opengl.GL11;

public class VertexBufferHolder
implements IVertexBufferHolder {
    public static final VertexFormat BUFFER_FORMAT = new VertexFormat(ImmutableList.of((Object)DefaultVertexFormats.field_181713_m, (Object)DefaultVertexFormats.field_181714_n, (Object)DefaultVertexFormats.field_181715_o, (Object)DefaultVertexFormats.field_181717_q, (Object)DefaultVertexFormats.field_181718_r));
    private static final Map<RenderType, List<BufferedJob>> JOBS = new IdentityHashMap<RenderType, List<BufferedJob>>();
    private final ResettableLazy<VertexBuffer> buffer;
    private final ResettableLazy<List<BakedQuad>> quads;

    private VertexBufferHolder(NonNullSupplier<List<BakedQuad>> quads) {
        this.quads = new ResettableLazy<List<BakedQuad>>(quads);
        this.buffer = new ResettableLazy(() -> {
            VertexBuffer vb = new VertexBuffer(BUFFER_FORMAT);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder bb = tes.func_178180_c();
            bb.func_181668_a(7, BUFFER_FORMAT);
            this.renderToBuilder((IVertexBuilder)bb, new MatrixStack(), 0, 0, false);
            bb.func_178977_d();
            vb.func_227875_a_(bb);
            return vb;
        }, VertexBuffer::close);
    }

    public static void addToAPI() {
        IVertexBufferHolder.CREATE.setValue(VertexBufferHolder::new);
    }

    @Override
    public void render(RenderType type, int light, int overlay, IRenderTypeBuffer directOut, MatrixStack transform, boolean inverted) {
        if (((Boolean)IEConfig.GENERAL.enableVBOs.get()).booleanValue()) {
            JOBS.computeIfAbsent(type, t -> new ArrayList()).add(new BufferedJob(this, light, overlay, transform, inverted));
        } else {
            this.renderToBuilder(directOut.getBuffer(type), transform, light, overlay, inverted);
        }
    }

    @Override
    public void reset() {
        this.buffer.reset();
        this.quads.reset();
    }

    private void renderToBuilder(IVertexBuilder builder, MatrixStack transform, int light, int overlay, boolean inverted) {
        if (inverted) {
            builder = new InvertingVertexBuffer(4, builder);
        }
        for (BakedQuad quad : this.quads.get()) {
            builder.func_227889_a_(transform.func_227866_c_(), quad, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }

    public static void afterTERRendering() {
        if (!JOBS.isEmpty()) {
            for (Map.Entry<RenderType, List<BufferedJob>> typeEntry : JOBS.entrySet()) {
                RenderType type = typeEntry.getKey();
                type.func_228547_a_();
                boolean inverted = false;
                for (BufferedJob job : typeEntry.getValue()) {
                    RenderSystem.glMultiTexCoord2f((int)33986, (float)(16 * LightTexture.func_228450_a_((int)job.light)), (float)(16 * LightTexture.func_228454_b_((int)job.light)));
                    RenderSystem.glMultiTexCoord2f((int)33985, (float)(job.overlay & 0xFFFF), (float)(job.overlay >>> 16));
                    if (job.inverted && !inverted) {
                        GL11.glCullFace((int)1028);
                    } else if (!job.inverted && inverted) {
                        GL11.glCullFace((int)1029);
                    }
                    inverted = job.inverted;
                    VertexBuffer buffer = ((BufferedJob)job).buffer.buffer.get();
                    buffer.func_177359_a();
                    BUFFER_FORMAT.func_227892_a_(0L);
                    buffer.func_227874_a_(job.transform, 7);
                }
                if (inverted) {
                    GL11.glCullFace((int)1029);
                }
                type.func_228549_b_();
            }
            VertexBuffer.func_177361_b();
            BUFFER_FORMAT.func_227895_d_();
            JOBS.clear();
        }
    }

    private static class BufferedJob {
        private final VertexBufferHolder buffer;
        private final int light;
        private final int overlay;
        private final Matrix4f transform;
        private final boolean inverted;

        private BufferedJob(VertexBufferHolder buffer, int light, int overlay, MatrixStack transform, boolean inverted) {
            this.buffer = buffer;
            this.light = light;
            this.overlay = overlay;
            this.transform = transform.func_227866_c_().func_227870_a_();
            this.inverted = inverted;
        }
    }
}

