/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class FeedthroughTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPropertyPassthrough,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ICacheData,
IEBlockInterfaces.IStateBasedDirectional {
    public static final String WIRE = "wire";
    private static final String OFFSET = "offset";
    public static final String MIDDLE_STATE = "middle";
    @Nonnull
    public WireType reference = WireType.COPPER;
    @Nonnull
    public BlockState stateForMiddle = Blocks.field_150346_d.func_176223_P();
    public int offset = 0;
    public boolean currentlyDisassembling = false;
    private VoxelShape aabb;

    public FeedthroughTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.FEEDTHROUGH.get()));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74778_a(WIRE, this.reference.getUniqueName());
        nbt.func_74768_a(OFFSET, this.offset);
        CompoundNBT stateNbt = NBTUtil.func_190009_a((BlockState)this.stateForMiddle);
        nbt.func_218657_a(MIDDLE_STATE, (INBT)stateNbt);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.reference = WireType.getValue(nbt.func_74779_i(WIRE));
        this.offset = nbt.func_74762_e(OFFSET);
        this.stateForMiddle = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l(MIDDLE_STATE));
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        double l = WireApi.INFOS.get((Object)this.reference).connOffset;
        int factor = here.equals(this.getPositivePoint()) ? 1 : -1;
        return new Vec3d(0.5 + (0.5 + l) * (double)this.getFacing().func_82601_c() * (double)factor, 0.5 + (0.5 + l) * (double)this.getFacing().func_96559_d() * (double)factor, 0.5 + (0.5 + l) * (double)this.getFacing().func_82599_e() * (double)factor);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (!WireApi.canMix(this.reference, cableType)) {
            return false;
        }
        Collection<Connection> existing = this.globalNet.getLocalNet(target).getConnections(target);
        for (Connection c : existing) {
            if (c.isInternal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.field_174879_c.func_177967_a(this.getFacing(), 1), (Object)this.field_174879_c.func_177967_a(this.getFacing(), -1));
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.field_174879_c.func_177967_a(this.getFacing(), -this.offset);
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(this.reference);
        if (this.offset == 0) {
            LootContext.Builder builder = new LootContext.Builder(context.func_202879_g()).func_216021_b(LootParameters.field_216289_i, context.func_216031_c(LootParameters.field_216289_i)).func_216021_b(LootParameters.field_216281_a, context.func_216031_c(LootParameters.field_216281_a)).func_216021_b(LootParameters.field_216286_f, context.func_216031_c(LootParameters.field_216286_f));
            return Utils.getDrops(this.stateForMiddle, builder);
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)info.conn.get().func_177230_c(), 1)});
    }

    @Override
    public ItemStack getPickBlock(@Nullable PlayerEntity player, BlockState state, RayTraceResult rayRes) {
        if (this.offset == 0) {
            return Utils.getPickBlock(this.stateForMiddle, rayRes, player);
        }
        return IEBlockInterfaces.ITileDrop.super.getPickBlock(player, state, rayRes);
    }

    @Override
    public void readOnPlacement(@Nullable LivingEntity placer, ItemStack stack) {
        this.reference = WireType.getValue(ItemNBTHelper.getString(stack, WIRE));
        this.stateForMiddle = NBTUtil.func_190008_d((CompoundNBT)ItemNBTHelper.getTagCompound(stack, MIDDLE_STATE));
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (this.offset == 0) {
            return VoxelShapes.func_197868_b();
        }
        if (this.aabb == null) {
            float[] tmp = new float[]{0.3125f, 0.0f, 0.3125f, 0.6875f, (float)WireApi.INFOS.get((Object)this.reference).connLength, 0.6875f};
            tmp = Utils.rotateToFacing(tmp, this.offset > 0 ? this.getFacing() : this.getFacing().func_176734_d());
            this.aabb = VoxelShapes.func_197873_a((double)tmp[0], (double)tmp[1], (double)tmp[2], (double)tmp[3], (double)tmp[4], (double)tmp[5]);
        }
        return this.aabb;
    }

    @Override
    public Object[] getCacheData() {
        return new Object[]{this.stateForMiddle, this.reference, this.getFacing()};
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 253) {
            this.checkLight();
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)this.getNegativePoint(), (Object)this.getPositivePoint());
    }

    public ConnectionPoint getNegativePoint() {
        return new ConnectionPoint(this.field_174879_c, FeedthroughTileEntity.getIndexForOffset(-1));
    }

    public ConnectionPoint getPositivePoint() {
        return new ConnectionPoint(this.field_174879_c, FeedthroughTileEntity.getIndexForOffset(1));
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of((Object)new Connection(this.field_174879_c, 0, 1));
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        if (offset.equals((Object)this.getFacing().func_176730_m())) {
            return this.getPositivePoint();
        }
        if (offset.equals((Object)this.getFacing().func_176734_d().func_176730_m())) {
            return this.getNegativePoint();
        }
        return null;
    }

    public static int getIndexForOffset(int offset) {
        if (offset == -1) {
            return 1;
        }
        if (offset == 1) {
            return 0;
        }
        return -1;
    }

    public static class FeedthroughData {
        public final BlockState baseState;
        public final WireType wire;
        public final Direction facing;
        public final int offset;
        public final Int2IntFunction colorMultiplier;

        public FeedthroughData(BlockState baseState, WireType wire, Direction facing, int offset, Int2IntFunction colorMultiplier) {
            this.baseState = baseState;
            this.wire = wire;
            this.facing = facing;
            this.offset = offset;
            this.colorMultiplier = colorMultiplier;
        }
    }
}

