/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.items.HammerItem;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class MetalLadderBlock
extends LadderBlock {
    private static final Map<Direction, VoxelShape> FRAMES = new EnumMap<Direction, VoxelShape>(Direction.class);
    private final CoverType type;

    private static VoxelShape merge(VoxelShape a, AxisAlignedBB b) {
        return VoxelShapes.func_197882_b((VoxelShape)a, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)b), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    }

    public MetalLadderBlock(CoverType type) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 15.0f).func_226896_b_());
        this.type = type;
        this.setRegistryName(new ResourceLocation("immersiveengineering", "metal_ladder_" + type.name().toLowerCase(Locale.US)));
        IEContent.registeredIEBlocks.add((Block)this);
        IEContent.registeredIEItems.add((Item)new BlockItemIE((Block)this));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        VoxelShape base = super.func_220053_a(state, world, pos, ctx);
        if (this.type == CoverType.NONE) {
            return base;
        }
        Direction ladderSide = (Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a);
        return VoxelShapes.func_197882_b((VoxelShape)base, (VoxelShape)FRAMES.get(ladderSide), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return super.isToolEffective(state, tool) || tool == HammerItem.HAMMER_TOOL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState baseState = super.func_196258_a(ctx);
        if (this.type == CoverType.NONE || baseState == null) {
            return baseState;
        }
        return (BlockState)baseState.func_206870_a((IProperty)LadderBlock.field_176382_a, (Comparable)Direction.func_176733_a((double)ctx.func_195990_h()).func_176734_d());
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (this.type == CoverType.NONE) {
            return super.func_196260_a(state, world, pos);
        }
        return true;
    }

    static {
        for (Direction dir : Direction.field_176754_o) {
            VoxelShape forDir = VoxelShapes.func_197880_a();
            if (dir != Direction.NORTH) {
                forDir = MetalLadderBlock.merge(forDir, new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
            }
            if (dir != Direction.EAST) {
                forDir = MetalLadderBlock.merge(forDir, new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
            }
            if (dir != Direction.SOUTH) {
                forDir = MetalLadderBlock.merge(forDir, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
            }
            if (dir != Direction.WEST) {
                forDir = MetalLadderBlock.merge(forDir, new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
            }
            FRAMES.put(dir, forDir);
        }
    }

    public static enum CoverType {
        NONE,
        ALU,
        STEEL;

    }
}

