/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.EntityCollisionTracker;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BasicConveyor
implements ConveyorHandler.IConveyorBelt {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "basic");
    public Block cover = Blocks.field_150350_a;
    ConveyorHandler.ConveyorDirection direction = ConveyorHandler.ConveyorDirection.HORIZONTAL;
    @Nullable
    DyeColor dyeColour = null;
    private final TileEntity tile;
    protected final EntityCollisionTracker collisionTracker = new EntityCollisionTracker(10);
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/conveyor");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/off");
    private static final AxisAlignedBB topBox = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    private static final CachedVoxelShapes<ShapeKey> SHAPES = new CachedVoxelShapes<ShapeKey>(BasicConveyor::getBoxes);
    public static ArrayList<Predicate<Block>> validCoveyorCovers = new ArrayList();

    public BasicConveyor(TileEntity tile) {
        this.tile = tile;
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return this.direction;
    }

    @Override
    public boolean changeConveyorDirection() {
        if (!this.tile.func_145831_w().field_72995_K) {
            this.direction = this.direction == ConveyorHandler.ConveyorDirection.HORIZONTAL ? ConveyorHandler.ConveyorDirection.UP : (this.direction == ConveyorHandler.ConveyorDirection.UP ? ConveyorHandler.ConveyorDirection.DOWN : ConveyorHandler.ConveyorDirection.HORIZONTAL);
        }
        return true;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        this.direction = dir;
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public boolean isCovered() {
        return false;
    }

    public static Block getDefaultCover() {
        return IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD);
    }

    @Override
    public void onEntityCollision(@Nonnull Entity entity) {
        this.collisionTracker.onEntityCollided(entity);
        ConveyorHandler.IConveyorBelt.super.onEntityCollision(entity);
        if (this.isCovered() && entity instanceof ItemEntity) {
            ((ItemEntity)entity).func_174867_a(10);
        }
    }

    @Override
    public boolean isBlocked() {
        return this.collisionTracker.getCollidedInRange(this.getTile().func_145831_w().func_82737_E()) > 2;
    }

    @Override
    public void onItemDeployed(ItemEntity entity) {
        ConveyorHandler.IConveyorBelt.super.onItemDeployed(entity);
        if (this.isCovered()) {
            entity.func_174867_a(10);
        }
    }

    @Override
    public boolean playerInteraction(PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        if (this.isCovered()) {
            return this.handleCoverInteraction(player, hand, heldItem);
        }
        return false;
    }

    @Override
    public CompoundNBT writeConveyorNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("direction", this.direction.ordinal());
        if (this.dyeColour != null) {
            nbt.func_74768_a("dyeColour", this.dyeColour.func_196059_a());
        }
        if (this.isCovered() && this.cover != Blocks.field_150350_a) {
            nbt.func_74778_a("cover", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.cover).toString());
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundNBT nbt) {
        this.direction = ConveyorHandler.ConveyorDirection.values()[nbt.func_74762_e("direction")];
        this.dyeColour = nbt.func_150297_b("dyeColour", 3) ? DyeColor.func_196056_a((int)nbt.func_74762_e("dyeColour")) : null;
        if (this.isCovered()) {
            this.cover = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("cover")));
        }
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }

    @Override
    public boolean canBeDyed() {
        return true;
    }

    @Override
    public boolean setDyeColour(DyeColor colour) {
        if (colour == this.dyeColour) {
            return false;
        }
        this.dyeColour = colour;
        return true;
    }

    @Override
    public DyeColor getDyeColour() {
        return this.dyeColour;
    }

    @Override
    public String getModelCacheKey() {
        String key = ConveyorHandler.IConveyorBelt.super.getModelCacheKey();
        if (this.isCovered() && this.cover != Blocks.field_150350_a) {
            key = key + "s" + this.cover.getRegistryName();
        }
        return key;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
        if (this.isCovered()) {
            this.addCoverToQuads(baseModel);
        }
        return baseModel;
    }

    @Override
    public VoxelShape getCollisionShape() {
        VoxelShape baseShape = ConveyorHandler.IConveyorBelt.super.getCollisionShape();
        if (this.isCovered()) {
            return SHAPES.get(new ShapeKey(this, true, baseShape));
        }
        return baseShape;
    }

    @Override
    public VoxelShape getSelectionShape() {
        if (this.isCovered()) {
            return SHAPES.get(new ShapeKey(this, false, null));
        }
        return ConveyorHandler.IConveyorBelt.super.getSelectionShape();
    }

    private static List<AxisAlignedBB> getBoxes(ShapeKey key) {
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>();
        if (key.superShape != null) {
            ret.addAll(key.superShape.func_197756_d());
        }
        if (key.direction == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            if (!key.collision) {
                return ImmutableList.of((Object)FULL_BLOCK.func_197752_a());
            }
            ret.add(topBox);
        } else {
            boolean up = key.direction == ConveyorHandler.ConveyorDirection.UP;
            boolean collision = key.collision;
            Direction facing = key.facing;
            ret.add(new AxisAlignedBB(facing == Direction.WEST && !up || facing == Direction.EAST && up ? 0.5 : 0.0, collision ? 1.75 : 0.5, facing == Direction.NORTH && !up || facing == Direction.SOUTH && up ? 0.5 : 0.0, facing == Direction.WEST && up || facing == Direction.EAST && !up ? 0.5 : 1.0, 2.0, facing == Direction.NORTH && up || facing == Direction.SOUTH && !up ? 0.5 : 1.0));
            ret.add(new AxisAlignedBB(facing == Direction.WEST && up || facing == Direction.EAST && !up ? 0.5 : 0.0, collision ? 1.25 : 0.0, facing == Direction.NORTH && up || facing == Direction.SOUTH && !up ? 0.5 : 0.0, facing == Direction.WEST && !up || facing == Direction.EAST && up ? 0.5 : 1.0, 1.5, facing == Direction.NORTH && !up || facing == Direction.SOUTH && up ? 0.5 : 1.0));
        }
        return ret;
    }

    protected void addCoverToQuads(List<BakedQuad> baseModel) {
        Block b = this.cover != Blocks.field_150350_a ? this.cover : BasicConveyor.getDefaultCover();
        BlockState state = b.func_176223_P();
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (model != null) {
            Direction facing = this.getFacing();
            ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
            TextureAtlasSprite sprite = model.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
            HashMap<Direction, TextureAtlasSprite> sprites = new HashMap<Direction, TextureAtlasSprite>();
            for (Direction f2 : Direction.field_199792_n) {
                for (BakedQuad q : model.func_200117_a(state, f2, Utils.RAND)) {
                    if (q == null || q.func_187508_a() == null) continue;
                    sprites.put(f2, q.func_187508_a());
                }
            }
            for (BakedQuad q : model.func_200117_a(state, null, Utils.RAND)) {
                if (q == null || q.func_187508_a() == null || q.func_178210_d() == null) continue;
                sprites.put(q.func_178210_d(), q.func_187508_a());
            }
            Function<Direction, TextureAtlasSprite> getSprite = f -> sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite;
            Function<Direction, TextureAtlasSprite> getSpriteHorizontal = f -> f.func_176740_k() == Direction.Axis.Y ? null : (sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite);
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            Matrix4 matrix = new Matrix4(facing);
            Function<Vec3d[], Vec3d[]> vertexTransformer = conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL ? vertices -> vertices : vertices -> {
                Vec3d[] ret = new Vec3d[((Vec3d[])vertices).length];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = new Vec3d(vertices[i].field_72450_a, vertices[i].field_72448_b + (double)(vertices[i].field_72449_c == (double)(conDir != ConveyorHandler.ConveyorDirection.UP ? 1 : 0) ? 1 : 0), vertices[i].field_72449_c);
                }
                return ret;
            };
            baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.75, 0.0), new Vec3d(1.0, 1.0, 1.0), matrix, facing, vertexTransformer, getSprite, colour));
            if (this.getTile() == null || this.renderWall(this.getFacing(), 0)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.1875, 0.0), new Vec3d(0.0625, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.1875, 0.0), new Vec3d(0.0625, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.1875, 0.9375), new Vec3d(0.0625, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
            }
            if (this.getTile() == null || this.renderWall(this.getFacing(), 1)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.9375, 0.1875, 0.0), new Vec3d(1.0, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.9375, 0.1875, 0.0), new Vec3d(1.0, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.9375, 0.1875, 0.9375), new Vec3d(1.0, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
            }
        }
    }

    public void dropCover(PlayerEntity player) {
        ItemEntity entityitem;
        if (this.tile != null && !this.tile.func_145831_w().field_72995_K && this.cover != Blocks.field_150350_a && this.tile.func_145831_w().func_82736_K().func_223586_b(GameRules.field_223603_f) && (entityitem = player.func_71019_a(new ItemStack((IItemProvider)this.cover), false)) != null) {
            entityitem.func_174868_q();
        }
    }

    protected boolean handleCoverInteraction(PlayerEntity player, Hand hand, ItemStack heldItem) {
        Block heldBlock;
        if (heldItem.func_190926_b() && player.func_225608_bj_() && this.cover != Blocks.field_150350_a) {
            this.dropCover(player);
            this.cover = Blocks.field_150350_a;
            return true;
        }
        if (!heldItem.func_190926_b() && !player.func_225608_bj_() && (heldBlock = Block.func_149634_a((Item)heldItem.func_77973_b())) != Blocks.field_150350_a) {
            for (Predicate<Block> func : validCoveyorCovers) {
                if (!func.test(heldBlock) || heldBlock == this.cover) continue;
                this.dropCover(player);
                this.cover = heldBlock;
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    player.func_184611_a(hand, heldItem);
                }
                return true;
            }
        }
        return false;
    }

    protected final boolean isPowered() {
        TileEntity te = this.getTile();
        if (te instanceof ConveyorBeltTileEntity) {
            return ((ConveyorBeltTileEntity)te).isRSPowered();
        }
        return te.func_145831_w().func_175687_A(te.func_174877_v()) > 0;
    }

    static {
        validCoveyorCovers.add(arg_0 -> IETags.scaffoldingAlu.func_199685_a_(arg_0));
        validCoveyorCovers.add(arg_0 -> IETags.scaffoldingSteel.func_199685_a_(arg_0));
        validCoveyorCovers.add(input -> input == IEBlocks.WoodenDecoration.treatedScaffolding);
        validCoveyorCovers.add(arg_0 -> ((Tag)Tags.Blocks.GLASS).func_199685_a_(arg_0));
    }

    private static class ShapeKey {
        private final ConveyorHandler.ConveyorDirection direction;
        private final boolean collision;
        private final Direction facing;
        @Nullable
        private final VoxelShape superShape;

        public ShapeKey(BasicConveyor conveyor, boolean collision, @Nullable VoxelShape superShape) {
            this.direction = conveyor.getConveyorDirection();
            this.collision = collision;
            this.facing = conveyor.getFacing();
            this.superShape = superShape;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShapeKey shapeKey = (ShapeKey)o;
            return this.collision == shapeKey.collision && this.direction == shapeKey.direction && this.facing == shapeKey.facing && Objects.equals(this.superShape, shapeKey.superShape);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.direction, this.collision, this.facing, this.superShape});
        }
    }
}

